/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.jsonb;

import com.icthh.xm.commons.migration.db.jsonb.CustomDialect;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.BinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class CustomPostgreSQLDialect
extends PostgreSQLDialect
implements CustomDialect {
    public static final String JSON_QUERY_TEMPLATE = "jsonb_path_query_first(?1, ?2::jsonpath)";
    public static final String JSON_EXTRACT_PATH = "jsonb_extract_path_text";
    public static final String JSON_EXTRACT_PATH_TEMPLATE = "jsonb_to_string";
    public static final String TO_JSON_B = "to_json_b";
    public static final String TO_JSON_B_TEMPLATE = "to_jsonb(?1)";

    public CustomPostgreSQLDialect(FunctionContributions functionContributions) {
        BasicType stringBasicType = functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.registerPattern("json_query", JSON_QUERY_TEMPLATE, stringBasicType);
        functionRegistry.registerPattern(TO_JSON_B, TO_JSON_B_TEMPLATE, stringBasicType);
        functionRegistry.registerPattern(JSON_EXTRACT_PATH_TEMPLATE, JSON_EXTRACT_PATH, stringBasicType);
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == 2004) {
            return BinaryJdbcType.INSTANCE;
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }
}

