/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db;

import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.MultiTenantSpringLiquibase;
import liquibase.integration.spring.SpringLiquibase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.CollectionUtils;

public class XmMultiTenantSpringLiquibase
extends MultiTenantSpringLiquibase {
    private static final Logger log = LoggerFactory.getLogger(XmMultiTenantSpringLiquibase.class);
    private ResourceLoader resourceLoader;

    public void afterPropertiesSet() throws Exception {
        if (this.getDataSource() == null && this.getSchemas() == null) {
            super.afterPropertiesSet();
        } else {
            if (this.getDataSource() == null && this.getSchemas() != null) {
                throw new LiquibaseException("When schemas are defined you should also define a base dataSource");
            }
            if (this.getDataSource() != null) {
                log.info("Schema based multitenancy enabled");
                if (CollectionUtils.isEmpty((Collection)this.getSchemas())) {
                    log.warn("Schemas not defined, using defaultSchema only");
                    this.setSchemas(new ArrayList());
                    this.getSchemas().add(this.getDefaultSchema());
                }
                this.runOnAllSchemasXm();
            }
        }
    }

    private void runOnAllSchemasXm() throws LiquibaseException {
        for (String schema : this.getSchemas()) {
            if (schema.equals("default")) {
                schema = null;
            }
            log.info("Initializing Liquibase for schema {}", (Object)schema);
            try {
                SpringLiquibase liquibase = this.getXmSpringLiquibase(this.getDataSource());
                liquibase.setDefaultSchema(schema);
                liquibase.afterPropertiesSet();
                log.info("Liquibase run for schema {}", (Object)schema);
            }
            catch (Exception e) {
                log.error("Failed to initialize Liquibase for schema {}", (Object)schema, (Object)e);
            }
        }
    }

    private SpringLiquibase getXmSpringLiquibase(DataSource dataSource) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setChangeLog(this.getChangeLog());
        liquibase.setChangeLogParameters(this.getParameters());
        liquibase.setContexts(this.getContexts());
        liquibase.setLabels(this.getLabels());
        liquibase.setDropFirst(this.isDropFirst());
        liquibase.setShouldRun(this.isShouldRun());
        liquibase.setRollbackFile(this.getRollbackFile());
        liquibase.setResourceLoader(this.getResourceLoader());
        liquibase.setDataSource(dataSource);
        liquibase.setDefaultSchema(this.getDefaultSchema());
        return liquibase;
    }

    private ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.resourceLoader = resourceLoader;
    }
}

