/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.liquibase;

import com.icthh.xm.commons.tenant.TenantContextUtils;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class LiquibaseRunner {
    private static final Logger log = LoggerFactory.getLogger(LiquibaseRunner.class);
    private final ResourceLoader resourceLoader;
    private final DataSource dataSource;
    private final LiquibaseProperties liquibaseProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnTenant(String tenantKey, String changelogPath) {
        StopWatch stopWatch = StopWatch.createStarted();
        log.info("start Liquibase migration for tenant {}, changelog path: {}", (Object)tenantKey, (Object)changelogPath);
        try {
            String schema = TenantContextUtils.normalizeTenant((String)tenantKey);
            SpringLiquibase liquibase = new SpringLiquibase();
            liquibase.setResourceLoader(this.resourceLoader);
            liquibase.setDataSource(this.dataSource);
            liquibase.setChangeLog(changelogPath);
            liquibase.setContexts(this.liquibaseProperties.getContexts());
            liquibase.setDefaultSchema(schema);
            liquibase.setDropFirst(this.liquibaseProperties.isDropFirst());
            liquibase.setChangeLogParameters(this.liquibaseProperties.getParameters());
            liquibase.setShouldRun(this.liquibaseProperties.isEnabled());
            liquibase.afterPropertiesSet();
        }
        finally {
            log.info("stop  Liquibase migration for tenant {}, time: {} ms", (Object)tenantKey, (Object)stopWatch.getTime());
        }
    }

    public LiquibaseRunner(ResourceLoader resourceLoader, DataSource dataSource, LiquibaseProperties liquibaseProperties) {
        this.resourceLoader = resourceLoader;
        this.dataSource = dataSource;
        this.liquibaseProperties = liquibaseProperties;
    }
}

