/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.tenant;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DropSchemaResolver {
    private static final Logger log = LoggerFactory.getLogger(DropSchemaResolver.class);
    private static final String DEFAULT_COMMAND = "DROP SCHEMA IF EXISTS %s";
    private static final Map<String, String> DB_COMMANDS = new HashMap<String, String>();
    private String dbDropSchemaCommand;

    public DropSchemaResolver(Environment env) {
        String db = env.getProperty("spring.jpa.database");
        this.dbDropSchemaCommand = DB_COMMANDS.getOrDefault(db, DEFAULT_COMMAND);
        log.info("Database {} will use command '{}' for drop schema", (Object)db, (Object)this.dbDropSchemaCommand);
    }

    public String getSchemaDropCommand() {
        return this.dbDropSchemaCommand;
    }

    static {
        DB_COMMANDS.put("POSTGRESQL", "DROP SCHEMA IF EXISTS %s CASCADE");
        DB_COMMANDS.put("H2", DEFAULT_COMMAND);
    }
}

