/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.tenant.hibernate;

import com.icthh.xm.commons.migration.db.tenant.SchemaChangeResolver;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.springframework.stereotype.Component;

@Component
public class MultiTenantConnectionProviderImpl
implements MultiTenantConnectionProvider {
    private static final long serialVersionUID = 1L;
    private final transient DataSource dataSource;
    private final SchemaChangeResolver resolver;

    public Connection getAnyConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseAnyConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public Connection getConnection(String tenantIdentifier) throws SQLException {
        Connection connection = this.getAnyConnection();
        try (Statement statement = connection.createStatement();){
            statement.execute(String.format(this.resolver.getSchemaSwitchCommand(), tenantIdentifier));
        }
        catch (SQLException e) {
            throw new HibernateException("Could not alter JDBC connection to specified schema [" + tenantIdentifier + "]", (Throwable)e);
        }
        return connection;
    }

    public void releaseConnection(String tenantIdentifier, Connection connection) throws SQLException {
        connection.close();
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return false;
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return null;
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    @ConstructorProperties(value={"dataSource", "resolver"})
    public MultiTenantConnectionProviderImpl(DataSource dataSource, SchemaChangeResolver resolver) {
        this.dataSource = dataSource;
        this.resolver = resolver;
    }
}

