/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.util;

import com.icthh.xm.commons.logging.LoggingAspectConfig;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;

public final class AopAnnotationUtils {
    public static Optional<LoggingAspectConfig> getConfigAnnotation(JoinPoint joinPoint) {
        Optional<Method> method = AopAnnotationUtils.getCallingMethod(joinPoint);
        Optional<LoggingAspectConfig> result = method.map(m -> (LoggingAspectConfig)AnnotationUtils.findAnnotation((Method)m, LoggingAspectConfig.class));
        if (!result.isPresent()) {
            Optional<Class> clazz = AopAnnotationUtils.getDeclaringClass(joinPoint);
            result = clazz.map(aClass -> (LoggingAspectConfig)AnnotationUtils.getAnnotation((AnnotatedElement)aClass, LoggingAspectConfig.class));
        }
        return result;
    }

    private static Optional<Method> getCallingMethod(JoinPoint joinPoint) {
        if (joinPoint != null && joinPoint.getSignature() != null && joinPoint.getSignature() instanceof MethodSignature) {
            MethodSignature ms = (MethodSignature)joinPoint.getSignature();
            return Optional.ofNullable(ms.getMethod());
        }
        return Optional.empty();
    }

    private static Optional<Class> getDeclaringClass(JoinPoint joinPoint) {
        if (AopAnnotationUtils.hasSignature(joinPoint)) {
            return Optional.ofNullable(joinPoint.getSignature().getDeclaringType());
        }
        return Optional.empty();
    }

    private static boolean hasSignature(JoinPoint joinPoint) {
        return joinPoint != null && joinPoint.getSignature() != null;
    }

    private AopAnnotationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

