/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.web.aop;

import com.icthh.xm.commons.logging.config.LoggingConfig;
import com.icthh.xm.commons.logging.config.LoggingConfigService;
import com.icthh.xm.commons.logging.util.BasePackageDetector;
import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.logging.web.util.WebLogObjectPrinter;
import java.util.Arrays;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Aspect
public class RestLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(RestLoggingAspect.class);
    private static final String XM_BASE_PACKAGE = "com.icthh.xm";
    private static final String LOG_START_PATTERN = "START {} : {} --> {}, input: {}";
    private static final String LOG_STOP_PATTERN = "STOP  {} : {} --> {}, result: {}, time = {} ms";
    private static final String LOG_ERROR_PATTERN = "STOP  {} : {} --> {}, error: {}, time = {} ms";
    private final LoggingConfigService loggingConfigService;
    private final BasePackageDetector basePackageDetector;
    @Value(value="${base-package:'-'}")
    private String basePackage;

    private boolean withLogging(String className) {
        String detectedBasePackage = this.basePackageDetector.getBasePackage();
        return className.startsWith(XM_BASE_PACKAGE) || className.startsWith(this.basePackage) || className.startsWith(detectedBasePackage);
    }

    @Pointcut(value="@target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerGetPointcut(RequestMapping controllerMapping, GetMapping methodMapping) {
    }

    @Pointcut(value="@target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerPostPointcut(RequestMapping controllerMapping, PostMapping methodMapping) {
    }

    @Pointcut(value="@target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerPutPointcut(RequestMapping controllerMapping, PutMapping methodMapping) {
    }

    @Pointcut(value="@target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerDeletePointcut(RequestMapping controllerMapping, DeleteMapping methodMapping) {
    }

    @Before(value="restControllerGetPointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, GetMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.GET.name(), controllerMapping.value(), methodMapping.value());
    }

    @Before(value="restControllerPostPointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, PostMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.POST.name(), controllerMapping.value(), methodMapping.value());
    }

    @Before(value="restControllerPutPointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, PutMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.PUT.name(), controllerMapping.value(), methodMapping.value());
    }

    @Before(value="restControllerDeletePointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, DeleteMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.DELETE.name(), controllerMapping.value(), methodMapping.value());
    }

    @AfterReturning(value="restControllerGetPointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, GetMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.GET.name(), controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterReturning(value="restControllerPostPointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, PostMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.POST.name(), controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterReturning(value="restControllerPutPointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, PutMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.PUT.name(), controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterReturning(value="restControllerDeletePointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, DeleteMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.DELETE.name(), controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterThrowing(value="restControllerGetPointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, GetMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.GET.name(), controllerMapping.value(), methodMapping.value(), e);
    }

    @AfterThrowing(value="restControllerPostPointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, PostMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.POST.name(), controllerMapping.value(), methodMapping.value(), e);
    }

    @AfterThrowing(value="restControllerPutPointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, PutMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.PUT.name(), controllerMapping.value(), methodMapping.value(), e);
    }

    @AfterThrowing(value="restControllerDeletePointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, DeleteMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.DELETE.name(), controllerMapping.value(), methodMapping.value(), e);
    }

    @Pointcut(value="@target(controllerMapping) && @annotation(methodMapping)")
    public void swaggerGeneratedEndpoint(RequestMapping controllerMapping, RequestMapping methodMapping) {
    }

    @Before(value="swaggerGeneratedEndpoint(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, RequestMapping methodMapping) {
        this.logStart(joinPoint, this.renderMethod(methodMapping.method()), controllerMapping.value(), methodMapping.value());
    }

    @AfterReturning(value="swaggerGeneratedEndpoint(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, RequestMapping methodMapping, Object result) {
        this.logStop(joinPoint, this.renderMethod(methodMapping.method()), controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterThrowing(value="swaggerGeneratedEndpoint(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, RequestMapping methodMapping, Throwable e) {
        this.logError(joinPoint, this.renderMethod(methodMapping.method()), controllerMapping.value(), methodMapping.value(), e);
    }

    private void logStart(JoinPoint joinPoint, String method, String[] controllerPath, String[] methodPath) {
        String methodName;
        Signature signature = joinPoint.getSignature();
        String className = signature.getDeclaringTypeName();
        if (!this.withLogging(className)) {
            return;
        }
        Class declaringType = signature.getDeclaringType();
        className = declaringType.getSimpleName();
        String packageName = declaringType.getPackageName();
        LoggingConfig.LogConfiguration config = this.loggingConfigService.getApiLoggingConfig(packageName, className, methodName = signature.getName());
        if (config == null) {
            log.info(LOG_START_PATTERN, new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), LogObjectPrinter.printInputParams((JoinPoint)joinPoint, (String[])new String[0])});
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)config.getLevel())) {
            return;
        }
        LogObjectPrinter.logWithLevel((Logger)log, (LogObjectPrinter.Level)config.getLevel(), (String)LOG_START_PATTERN, (Object[])new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), LogObjectPrinter.printInputParams((JoinPoint)joinPoint, (LoggingConfig.LogConfiguration.LogInput)config.getLogInput())});
    }

    private void logStop(JoinPoint joinPoint, String method, String[] controllerPath, String[] methodPath, Object result) {
        String methodName;
        Signature signature = joinPoint.getSignature();
        String className = signature.getDeclaringTypeName();
        if (!this.withLogging(className)) {
            return;
        }
        Class declaringType = signature.getDeclaringType();
        className = declaringType.getSimpleName();
        String packageName = declaringType.getPackageName();
        LoggingConfig.LogConfiguration config = this.loggingConfigService.getApiLoggingConfig(packageName, className, methodName = signature.getName());
        if (config == null) {
            log.info(LOG_STOP_PATTERN, new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), WebLogObjectPrinter.printRestResult(joinPoint, result), MdcUtils.getExecTimeMs()});
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)config.getLevel())) {
            return;
        }
        boolean printResult = true;
        if (Objects.nonNull(config.getLogResult()) && Objects.nonNull(config.getLogResult().getResultDetails())) {
            printResult = config.getLogResult().getResultDetails();
        }
        LogObjectPrinter.logWithLevel((Logger)log, (LogObjectPrinter.Level)config.getLevel(), (String)LOG_STOP_PATTERN, (Object[])new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), WebLogObjectPrinter.printRestResult(joinPoint, result, printResult), MdcUtils.getExecTimeMs()});
    }

    private void logError(JoinPoint joinPoint, String method, String[] controllerPath, String[] methodPath, Throwable e) {
        String className = joinPoint.getSignature().getDeclaringTypeName();
        if (!this.withLogging(className)) {
            return;
        }
        log.error(LOG_ERROR_PATTERN, new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), LogObjectPrinter.printExceptionWithStackInfo((Throwable)e), MdcUtils.getExecTimeMs()});
    }

    private String renderMethod(RequestMethod[] method) {
        if (method != null && method.length == 1) {
            return method[0].name();
        }
        return Arrays.toString(method);
    }

    public RestLoggingAspect(LoggingConfigService loggingConfigService, BasePackageDetector basePackageDetector) {
        this.loggingConfigService = loggingConfigService;
        this.basePackageDetector = basePackageDetector;
    }
}

