/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.trace;

import brave.Span;
import brave.Tracer;
import brave.kafka.clients.KafkaTracing;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.instrument.messaging.TracingChannelInterceptor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Component;

@Component
public class SleuthWrapper {
    private static final Logger log = LoggerFactory.getLogger(SleuthWrapper.class);
    private static final String SPAN_NAME_FROM_MESSAGE = "on-message";
    private final Tracer tracer;
    private KafkaTracing kafkaTracing;
    private TracingChannelInterceptor tracingChannelInterceptor;

    public SleuthWrapper(Tracer tracer) {
        this.tracer = tracer;
    }

    @Autowired(required=false)
    public void setKafkaTracing(KafkaTracing kafkaTracing) {
        this.kafkaTracing = kafkaTracing;
    }

    @Autowired(required=false)
    public void setTracingChannelInterceptor(TracingChannelInterceptor tracingChannelInterceptor) {
        this.tracingChannelInterceptor = tracingChannelInterceptor;
    }

    public void runWithSleuth(ConsumerRecord<?, ?> record, Runnable codeToRun) {
        Span kafkaSpan = this.kafkaTracing.nextSpan(record).name(SPAN_NAME_FROM_MESSAGE).start();
        this.runWithExistingSpan(kafkaSpan, codeToRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithSleuth(Message<?> message, MessageChannel channel, Runnable codeToRun) {
        this.tracingChannelInterceptor.postReceive(message, channel);
        Exception exceptionFromExecution = null;
        try {
            codeToRun.run();
        }
        catch (Exception e) {
            exceptionFromExecution = e;
        }
        finally {
            this.tracingChannelInterceptor.afterReceiveCompletion(message, channel, exceptionFromExecution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithExistingSpan(Span existingSpan, Runnable codeToRun) {
        log.trace("Opening span, {}", (Object)existingSpan.context().spanIdString());
        try (Tracer.SpanInScope spanInScope = this.tracer.withSpanInScope(existingSpan);){
            codeToRun.run();
        }
        finally {
            log.trace("Closing span, {}", (Object)existingSpan.context().spanIdString());
            existingSpan.finish();
        }
    }
}

