/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.api.LepEngineSession;
import com.icthh.xm.commons.lep.api.LepExecutorResolver;
import com.icthh.xm.commons.lep.api.LepManagementService;
import com.icthh.xm.commons.tenant.PrivilegedTenantContext;
import com.icthh.xm.commons.tenant.Tenant;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class LepThreadHelper {
    private final TenantContextHolder tenantContextHolder;
    private final LepManagementService lepManagementService;

    public LepThreadHelper(TenantContextHolder tenantContextHolder, LepManagementService lepManagementService) {
        this.tenantContextHolder = tenantContextHolder;
        this.lepManagementService = lepManagementService;
    }

    public <T> Future<T> runInThread(ExecutorService executorService, Callable<T> task) {
        return this.runInThread(executorService, task, SecurityContextHolder.getContext());
    }

    public <T> Future<T> runInThread(ExecutorService executorService, Callable<T> task, SecurityContext securityContext) {
        return executorService.submit(new LepThreadContext<T>(this.lepManagementService, task, this.tenantContextHolder, securityContext));
    }

    private static class LepThreadContext<T>
    implements Callable<T> {
        private final LepManagementService lepManagementService;
        private final LepExecutorResolver lepExecutorResolver;
        private final Callable<T> task;
        private final Tenant tenant;
        private final SecurityContext securityContext;
        private final PrivilegedTenantContext privilegedTenantContext;

        private LepThreadContext(LepManagementService lepManagementService, Callable<T> task, TenantContextHolder tenantContextHolder, SecurityContext securityContext) {
            this.lepManagementService = lepManagementService;
            this.lepExecutorResolver = lepManagementService.getCurrentLepExecutorResolver();
            this.task = task;
            this.privilegedTenantContext = tenantContextHolder.getPrivilegedContext();
            this.tenant = (Tenant)this.privilegedTenantContext.getTenant().orElseThrow(() -> new IllegalStateException("Tenant context doesn't have tenant key"));
            this.securityContext = securityContext;
        }

        @Override
        public T call() {
            return (T)this.privilegedTenantContext.execute(this.tenant, this::runInLepContext);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private T runInLepContext() {
            try {
                T t;
                block11: {
                    LepEngineSession threadContext = this.lepManagementService.beginThreadContext(this.lepExecutorResolver);
                    try {
                        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
                        t = this.task.call();
                        if (threadContext == null) break block11;
                        threadContext.close();
                    }
                    catch (Throwable throwable) {
                        if (threadContext != null) {
                            try {
                                threadContext.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                return t;
            }
            finally {
                SecurityContextHolder.clearContext();
            }
        }
    }
}

