/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.TargetProceedingLep;
import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.api.LepAdditionalContext;
import com.icthh.xm.commons.lep.api.LepContextFactory;
import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.commons.CommonsExecutor;
import com.icthh.xm.commons.lep.commons.CommonsService;
import com.icthh.xm.commons.lep.spring.LepContextCustomizer;
import com.icthh.xm.commons.lep.spring.LepContextService;
import com.icthh.xm.commons.lep.spring.LepThreadHelper;
import com.icthh.xm.commons.lep.spring.lepservice.LepServiceFactoryImpl;
import com.icthh.xm.commons.lep.spring.lepservice.LepServiceFactoryWithLepFactoryMethod;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.lep.api.LepMethod;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LepContextServiceImpl
implements LepContextService {
    private final LepContextFactory lepContextFactory;
    private final LepServiceFactoryWithLepFactoryMethod lepServiceFactory;
    private final LepThreadHelper lepThreadHelper;
    private final TenantContextHolder tenantContextHolder;
    private final XmAuthenticationContextHolder xmAuthContextHolder;
    private final List<LepAdditionalContext<?>> additionalContexts;
    private final List<LepContextCustomizer> customizers;
    private final CommonsService commonsService;

    @Override
    public final BaseLepContext createLepContext(LepEngine lepEngine, TargetProceedingLep lepMethod) {
        BaseLepContext baseLepContext = this.lepContextFactory.buildLepContext(lepMethod);
        this.buildUpInVars(lepMethod, baseLepContext);
        baseLepContext.lep = lepMethod;
        baseLepContext.thread = this.lepThreadHelper;
        baseLepContext.tenantContext = this.tenantContextHolder.getContext();
        baseLepContext.authContext = this.xmAuthContextHolder.getContext();
        baseLepContext.authContextHolder = this.xmAuthContextHolder;
        baseLepContext.commons = new CommonsExecutor(this.commonsService);
        this.additionalContexts.forEach(context -> {
            Object value = context.additionalContextValue(baseLepContext, lepEngine, lepMethod).map(Object.class::cast).orElse(context.additionalContextValue());
            baseLepContext.addAdditionalContext(context.additionalContextKey(), value);
        });
        baseLepContext.lepServices = new LepServiceFactoryImpl(lepEngine.getId(), this.lepServiceFactory);
        return this.customize(baseLepContext, lepEngine, lepMethod);
    }

    @Override
    public BaseLepContext customize(BaseLepContext lepContext, LepEngine lepEngine, TargetProceedingLep lepMethod) {
        for (LepContextCustomizer customizer : this.customizers) {
            lepContext = customizer.customize(lepContext, lepEngine, lepMethod);
        }
        return lepContext;
    }

    private void buildUpInVars(LepMethod lepMethod, BaseLepContext baseLepContext) {
        baseLepContext.inArgs = this.buildInArgsMap(lepMethod);
    }

    @Override
    public Map<String, Object> buildInArgsMap(LepMethod lepMethod) {
        String[] parameterNames = lepMethod.getMethodSignature().getParameterNames();
        Object[] methodArgValues = lepMethod.getMethodArgValues();
        LinkedHashMap<String, Object> inVars = new LinkedHashMap<String, Object>(parameterNames.length);
        for (int i = 0; i < parameterNames.length; ++i) {
            String paramName = parameterNames[i];
            Object paramValue = methodArgValues[i];
            inVars.put(paramName, paramValue);
        }
        return inVars;
    }

    public LepContextServiceImpl(LepContextFactory lepContextFactory, LepServiceFactoryWithLepFactoryMethod lepServiceFactory, LepThreadHelper lepThreadHelper, TenantContextHolder tenantContextHolder, XmAuthenticationContextHolder xmAuthContextHolder, List<LepAdditionalContext<?>> additionalContexts, List<LepContextCustomizer> customizers, CommonsService commonsService) {
        this.lepContextFactory = lepContextFactory;
        this.lepServiceFactory = lepServiceFactory;
        this.lepThreadHelper = lepThreadHelper;
        this.tenantContextHolder = tenantContextHolder;
        this.xmAuthContextHolder = xmAuthContextHolder;
        this.additionalContexts = additionalContexts;
        this.customizers = customizers;
        this.commonsService = commonsService;
    }
}

