/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl.engine;

import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.api.LepEngineFactory;
import com.icthh.xm.commons.lep.api.LepEngineSession;
import com.icthh.xm.commons.lep.api.LepExecutor;
import com.icthh.xm.commons.lep.api.LepExecutorResolver;
import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.commons.lep.api.LepManagementService;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.impl.engine.LepEngineManager;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LepManagementServiceImpl
implements LepManagementService {
    private static final Logger log = LoggerFactory.getLogger(LepManagementServiceImpl.class);
    private final AtomicBoolean isLepConfigInited = new AtomicBoolean(false);
    private final LepEngineManager lepEnginesManager = new LepEngineManager();
    private final ThreadLocal<LepExecutorResolver> tenantLepEnginesThreadContext = new ThreadLocal();
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final List<LepEngineFactory> engineFactories;
    private final TenantContextHolder tenantContextHolder;
    private final List<LepEngine.DestroyCallback> destroyCallbacks;

    public LepManagementServiceImpl(List<LepEngineFactory> engineFactories, TenantContextHolder tenantContextHolder, List<LepEngine.DestroyCallback> destroyCallbacks) {
        this.engineFactories = engineFactories;
        this.tenantContextHolder = tenantContextHolder;
        this.destroyCallbacks = destroyCallbacks;
    }

    @Override
    public boolean isLepEnginesInited() {
        return this.isLepConfigInited.get();
    }

    @Override
    public void refreshEngines(Map<String, List<XmLepConfigFile>> configInLepFolder) {
        log.info("START | Start lep engines refresh for tenants {}", configInLepFolder.keySet());
        log.trace("Start lep engines refresh by configs {}", configInLepFolder.values());
        configInLepFolder.keySet().forEach(tenantKey -> {
            StopWatch timer = StopWatch.createStarted();
            String tenant = tenantKey.toUpperCase();
            List<XmLepConfigFile> tenantConfigs = configInLepFolder.getOrDefault(tenantKey, Collections.emptyList());
            log.info("START | Create lep engines for tenant: {} | configInLepFolder.size: {}", (Object)tenant, (Object)tenantConfigs.size());
            log.trace("START | Create lep engines for tenant: {} | configInLepFolder.size: {}", (Object)tenant, tenantConfigs);
            List<LepEngine> engines = this.createEngines((String)tenantKey, tenantConfigs);
            engines.forEach(engine -> this.destroyCallbacks.forEach(engine::addDestroyCallback));
            this.lepEnginesManager.update(tenant, engines);
            log.info("STOP | Finish creating lep engines for tenant {}, {}ms", (Object)tenant, (Object)timer.getTime(TimeUnit.MILLISECONDS));
        });
        if (!this.isLepConfigInited.get() && this.isLepConfigInited.compareAndSet(false, true)) {
            this.countDownLatch.countDown();
        }
        log.info("STOP | Finish lep engines refresh");
    }

    private List<LepEngine> createEngines(String tenantKey, List<XmLepConfigFile> tenantConfigs) {
        return this.engineFactories.stream().map(it -> it.createLepEngine(tenantKey, tenantConfigs)).sorted(Comparator.comparingInt(LepEngine::order)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public LepExecutor getLepExecutor(LepKey lepKey) {
        this.assertLepConfigInited();
        this.assertLepEngineInited();
        LepExecutorResolver tenantLepEngines = this.getCurrentLepExecutorResolver();
        return tenantLepEngines.getLepExecutor(lepKey);
    }

    @Override
    public LepEngineSession beginThreadContext(LepExecutorResolver tenantLepEngines) {
        this.assertLepConfigInited();
        if (this.tenantLepEnginesThreadContext.get() != null) {
            throw new IllegalStateException("Lep thread context already inited");
        }
        this.setLepThreadContext(tenantLepEngines);
        tenantLepEngines.acquireUsage();
        return this::endThreadContext;
    }

    @Override
    public void runInLepContext(Runnable task) {
        try (LepEngineSession threadContext = this.beginThreadContext();){
            task.run();
        }
    }

    @Override
    public LepEngineSession beginThreadContext() {
        LepExecutorResolver tenantLepEngines;
        this.assertLepConfigInited();
        if (log.isDebugEnabled()) {
            log.debug("Init thread lep context | id: {}", (Object)System.identityHashCode(this));
        }
        if ((tenantLepEngines = this.tenantLepEnginesThreadContext.get()) == null) {
            String tenant = this.getTenantKeyFromThreadContext();
            tenantLepEngines = this.lepEnginesManager.acquireTenantLepEngine(tenant, tenantKey -> this.createEngines((String)tenantKey, List.of()));
            this.setLepThreadContext(tenantLepEngines);
            return this::endThreadContext;
        }
        this.endThreadContext();
        LepEngineSession threadContext = this.beginThreadContext();
        log.warn("Lep thread context recreated");
        return threadContext;
    }

    @Override
    public void endThreadContext() {
        LepExecutorResolver tenantLepEngines = this.tenantLepEnginesThreadContext.get();
        if (tenantLepEngines != null) {
            tenantLepEngines.releaseUsage();
        }
        this.removeLepThreadContext();
    }

    private void setLepThreadContext(LepExecutorResolver tenantLepEngines) {
        if (log.isDebugEnabled()) {
            log.debug("Lep context inited with tenantLepEngines: {} | thread: {}", (Object)tenantLepEngines, (Object)Thread.currentThread().getId());
        }
        this.tenantLepEnginesThreadContext.set(tenantLepEngines);
    }

    private void removeLepThreadContext() {
        this.tenantLepEnginesThreadContext.remove();
        if (log.isDebugEnabled()) {
            log.debug("End thread lep context | thread: {}", (Object)Thread.currentThread().getId());
        }
    }

    @Override
    public LepExecutorResolver getCurrentLepExecutorResolver() {
        return this.tenantLepEnginesThreadContext.get();
    }

    private String getTenantKeyFromThreadContext() {
        return TenantContextUtils.getRequiredTenantKeyValue((TenantContextHolder)this.tenantContextHolder).toUpperCase();
    }

    private void assertLepConfigInited() {
        if (!this.isLepConfigInited.get()) {
            log.warn("Lep engines not inited");
            this.countDownLatch.await();
        }
    }

    private void assertLepEngineInited() {
        if (this.tenantLepEnginesThreadContext.get() == null) {
            log.error("Lep thread context not inited | id: {} | thread: {}", (Object)System.identityHashCode(this), (Object)Thread.currentThread().getId());
            throw new IllegalStateException("Lep thread context not inited. Use try(var session = LepManagementService.beginThreadContext()){<you code>}");
        }
    }
}

