/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.lep.LepPathResolver;
import com.icthh.xm.commons.lep.RefreshTaskExecutor;
import com.icthh.xm.commons.lep.api.LepExecutorResolver;
import com.icthh.xm.commons.lep.api.LepManagementService;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.spring.LepUpdateMode;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.util.AntPathMatcher;

public class XmLepScriptConfigServerResourceLoader
implements RefreshableConfiguration,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(XmLepScriptConfigServerResourceLoader.class);
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, Map<String, XmLepConfigFile>> scriptsByTenant = new ConcurrentHashMap<String, Map<String, XmLepConfigFile>>();
    private final RefreshTaskExecutor refreshExecutor = new RefreshTaskExecutor();
    private final LepManagementService lepManagementService;
    private final LepUpdateMode lepUpdateMode;
    private final TenantContextHolder tenantContextHolder;
    private final LepPathResolver lepPathResolver;
    private final List<String> lepPathPatterns;

    public XmLepScriptConfigServerResourceLoader(LepPathResolver lepPathResolver, LepManagementService lepManagementService, LepUpdateMode lepUpdateMode, TenantContextHolder tenantContextHolder) {
        this.lepPathPatterns = lepPathResolver.getLepPathPatterns();
        this.lepPathResolver = lepPathResolver;
        this.lepManagementService = lepManagementService;
        this.lepUpdateMode = lepUpdateMode;
        this.tenantContextHolder = tenantContextHolder;
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.lepPathPatterns.stream().anyMatch(it -> this.pathMatcher.match(it, updatedKey));
    }

    public void onRefresh(String updatedKey, String configContent) {
        String tenant = this.lepPathResolver.getTenantFromPath(updatedKey);
        this.scriptsByTenant.computeIfAbsent(tenant, path -> new ConcurrentHashMap());
        if (StringUtils.isBlank((CharSequence)configContent)) {
            this.scriptsByTenant.get(tenant).remove(updatedKey);
        } else {
            XmLepConfigFile xmLepConfigFile = new XmLepConfigFile(updatedKey, configContent);
            this.scriptsByTenant.get(tenant).put(updatedKey, xmLepConfigFile);
        }
        this.refreshImmediatelyIfSynchronousMode(updatedKey);
    }

    private void refreshImmediatelyIfSynchronousMode(String updatedKey) throws InterruptedException, ExecutionException {
        if (LepUpdateMode.SYNCHRONOUS.equals((Object)this.lepUpdateMode)) {
            Set<String> tenantsToUpdate = this.getTenantsToUpdate(List.of(updatedKey));
            this.refreshEngines(tenantsToUpdate, false).get();
            LepExecutorResolver currentLepExecutorResolver = this.lepManagementService.getCurrentLepExecutorResolver();
            if (currentLepExecutorResolver != null && this.tenantContextHolder.getContext().isInitialized()) {
                this.lepManagementService.endThreadContext();
                this.lepManagementService.beginThreadContext();
            }
        }
    }

    public void refreshFinished(Collection<String> paths) {
        Set<String> tenantsToUpdate = this.getTenantsToUpdate(paths);
        Future<?> future = this.refreshEngines(tenantsToUpdate, false);
        if (LepUpdateMode.SYNCHRONOUS.equals((Object)this.lepUpdateMode)) {
            future.get();
        }
    }

    private Future<?> refreshEngines(Set<String> tenantsToUpdate, boolean isInit) {
        log.info("Submit task for update lep engines for tenants {}", tenantsToUpdate);
        return this.refreshExecutor.submit(() -> {
            try {
                if (isInit && this.lepManagementService.isLepEnginesInited()) {
                    return false;
                }
                Map<String, List<XmLepConfigFile>> configToUpdate = this.prepareConfigs(tenantsToUpdate);
                this.lepManagementService.refreshEngines(configToUpdate);
                return true;
            }
            catch (Throwable e) {
                log.error("Error during refresh configs: {}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        });
    }

    private Map<String, List<XmLepConfigFile>> prepareConfigs(Set<String> tenantsToUpdate) {
        Collection<XmLepConfigFile> envConfigs = this.getConfigByTenant("commons");
        HashMap<String, List<XmLepConfigFile>> configToUpdate = new HashMap<String, List<XmLepConfigFile>>();
        tenantsToUpdate.forEach(tenant -> {
            ArrayList<XmLepConfigFile> tenantConfigToUpdate = new ArrayList<XmLepConfigFile>();
            tenantConfigToUpdate.addAll(envConfigs);
            tenantConfigToUpdate.addAll(this.getConfigByTenant((String)tenant));
            configToUpdate.put((String)tenant, (List<XmLepConfigFile>)tenantConfigToUpdate);
        });
        return configToUpdate;
    }

    private Collection<XmLepConfigFile> getConfigByTenant(String tenant) {
        Map<String, XmLepConfigFile> configMap = this.scriptsByTenant.get(tenant);
        return configMap == null ? List.of() : configMap.values();
    }

    private Set<String> getTenantsToUpdate(Collection<String> paths) {
        TenantsByPathResponse tenantsByPaths = this.getTenantsByPaths(paths);
        if (tenantsByPaths.hasEnvCommons) {
            return this.scriptsByTenant.keySet();
        }
        return tenantsByPaths.getTenants();
    }

    public TenantsByPathResponse getTenantsByPaths(Collection<String> paths) {
        List tenantsInPath = paths.stream().map(this.lepPathResolver::getTenantFromPath).collect(Collectors.toList());
        boolean hasEnvCommons = tenantsInPath.stream().anyMatch("commons"::equals);
        Set<String> tenants = tenantsInPath.stream().filter(Predicate.not("commons"::equals)).collect(Collectors.toSet());
        return new TenantsByPathResponse(tenants, hasEnvCommons);
    }

    private void init() {
        StopWatch stopWatch = StopWatch.createStarted();
        Set<String> tenantsToUpdate = this.scriptsByTenant.keySet();
        log.info("START | Start init leps for tenants {}", tenantsToUpdate);
        this.refreshEngines(tenantsToUpdate, true).get();
        log.info("STOP | Leps inited, time: {}ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    public void refreshableConfigurationInited() {
        if (!this.lepManagementService.isLepEnginesInited()) {
            log.info("Init lep engine by refreshableConfigurationInited");
            this.init();
        }
    }

    @PostConstruct
    public void afterSingletonsInstantiated() {
        if (this.lepUpdateMode == LepUpdateMode.SYNCHRONOUS) {
            this.init();
        }
    }

    public static class TenantsByPathResponse {
        private final Set<String> tenants;
        private final boolean hasEnvCommons;

        public Set<String> getTenants() {
            return this.tenants;
        }

        public boolean isHasEnvCommons() {
            return this.hasEnvCommons;
        }

        public TenantsByPathResponse(Set<String> tenants, boolean hasEnvCommons) {
            this.tenants = tenants;
            this.hasEnvCommons = hasEnvCommons;
        }
    }
}

