/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.spring.DefaultLepContext;
import com.icthh.xm.commons.lep.spring.LepContextActualClassDetector;
import com.icthh.xm.commons.logging.util.BasePackageDetector;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLepContextActualClassDetector
implements LepContextActualClassDetector {
    private static final Logger log = LoggerFactory.getLogger(DefaultLepContextActualClassDetector.class);
    public static final String LEP_CONTEXT_DEFAULT_CLASS_NAME = "LepContext";
    private final BasePackageDetector basePackageDetector;

    @Override
    public Class<? extends BaseLepContext> detectActualClass() {
        String basePackage = this.basePackageDetector.getBasePackage();
        Reflections reflections = new Reflections(basePackage, new Scanner[0]);
        Set classes = reflections.getSubTypesOf(BaseLepContext.class);
        classes.remove(DefaultLepContext.class);
        this.removeParentClasses(classes);
        Class lepContextClass = DefaultLepContext.class;
        if (classes.size() == 1) {
            lepContextClass = (Class)classes.iterator().next();
        } else if (!classes.isEmpty()) {
            lepContextClass = classes.stream().filter(this::isNameLepContext).findFirst().orElseThrow(() -> {
                log.error("Can't find LepContext class in base package: {} | variants: {}", (Object)basePackage, (Object)classes);
                return new IllegalStateException("Can't find LepContext class in base package: " + basePackage);
            });
        }
        return lepContextClass;
    }

    private boolean isNameLepContext(Class<? extends BaseLepContext> type) {
        for (Class<? extends BaseLepContext> currentClass = type; currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!LEP_CONTEXT_DEFAULT_CLASS_NAME.equals(currentClass.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private void removeParentClasses(Set<Class<? extends BaseLepContext>> classList) {
        HashSet<Class<? extends BaseLepContext>> classesToRemove = new HashSet<Class<? extends BaseLepContext>>();
        block0: for (Class<? extends BaseLepContext> type : classList) {
            for (Class<? extends BaseLepContext> possibleChild : classList) {
                if (type == possibleChild || !type.isAssignableFrom(possibleChild)) continue;
                classesToRemove.add(type);
                continue block0;
            }
        }
        classList.removeAll(classesToRemove);
    }

    public DefaultLepContextActualClassDetector(BasePackageDetector basePackageDetector) {
        this.basePackageDetector = basePackageDetector;
    }
}

