/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl.engine;

import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.impl.engine.TenantLepEngine;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class LepEngineManager {
    private final Map<String, TenantLepEngine> enginesByTenants = new ConcurrentHashMap<String, TenantLepEngine>();

    LepEngineManager() {
    }

    public void update(String tenant, List<LepEngine> engines) {
        TenantLepEngine oldTenantLepEngines = this.enginesByTenants.get(tenant);
        this.enginesByTenants.put(tenant, new TenantLepEngine(tenant, engines));
        if (oldTenantLepEngines != null) {
            oldTenantLepEngines.acquireUsage();
            oldTenantLepEngines.destroy();
            oldTenantLepEngines.releaseUsage();
        }
    }

    public TenantLepEngine acquireTenantLepEngine(String tenant, Function<String, List<LepEngine>> engines) {
        TenantLepEngine tenantLepEngines = this.enginesByTenants.get(tenant);
        if (tenantLepEngines == null) {
            tenantLepEngines = this.enginesByTenants.computeIfAbsent(tenant, key -> new TenantLepEngine(tenant, (List)engines.apply(tenant)));
        }
        int retryCount = 0;
        tenantLepEngines.acquireUsage();
        while (!tenantLepEngines.isActive()) {
            tenantLepEngines.releaseUsage();
            if (++retryCount >= 3) {
                throw new IllegalStateException("Lep engine already closed");
            }
            tenantLepEngines = this.enginesByTenants.get(tenant);
        }
        return tenantLepEngines;
    }
}

