/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl;

import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.api.UseAsLepContext;
import com.icthh.xm.lep.api.MethodSignature;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodSignatureImpl
implements MethodSignature {
    private static final String[] STRINGS_EMPTY_ARRAY = new String[0];
    private final Class<?> declaringClass;
    private final List<String> parameterNames;
    private final Map<String, Integer> parameterIndexes;
    private final String[] parameterNamesArray;
    private final Method method;
    private final String declaringClassName;
    private final String lepContextMethodParameter;

    public MethodSignatureImpl(Method method, Class<?> targetType) {
        this.method = method;
        this.lepContextMethodParameter = this.calculateLepContextMethodParameter(method);
        this.parameterNames = this.calculateParametersNames(method);
        this.parameterIndexes = this.calculateParametersIndexes(this.parameterNames);
        this.parameterNamesArray = this.parameterNames.toArray(STRINGS_EMPTY_ARRAY);
        this.declaringClass = targetType;
        this.declaringClassName = this.declaringClass != null ? this.declaringClass.getName() : null;
    }

    private String calculateLepContextMethodParameter(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters != null) {
            return Arrays.stream(parameters).filter(p -> BaseLepContext.class.isAssignableFrom(p.getType())).filter(p -> p.getAnnotation(UseAsLepContext.class) != null).findAny().map(Parameter::getName).orElse(null);
        }
        return null;
    }

    private Map<String, Integer> calculateParametersIndexes(List<String> parameterNames) {
        HashMap<String, Integer> parameterIndexes = new HashMap<String, Integer>();
        for (int i = 0; i < parameterNames.size(); ++i) {
            parameterIndexes.put(parameterNames.get(i), i);
        }
        return Collections.unmodifiableMap(parameterIndexes);
    }

    private List<String> calculateParametersNames(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters == null) {
            return Collections.emptyList();
        }
        ArrayList<String> parameterNames = new ArrayList<String>(parameters.length);
        for (Parameter p : parameters) {
            parameterNames.add(p.getName());
        }
        return Collections.unmodifiableList(parameterNames);
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterNamesArray;
    }

    @Override
    public List<String> getParameterNamesList() {
        return this.parameterNames;
    }

    @Override
    public Integer getParameterIndex(String name) {
        return this.parameterIndexes.get(name);
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getLepContextMethodParameter() {
        return this.lepContextMethodParameter;
    }
}

