/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.commons.lep.spring.LepServiceHandler;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AspectForLepInBeanDetection {
    @Autowired
    private LepServiceHandler lepServiceHandler;

    @Around(value="@annotation(com.icthh.xm.commons.lep.LogicExtensionPoint)")
    public Object logicExtensionPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Class declaringType = signature.getDeclaringType();
        if (!declaringType.isAnnotationPresent(LepService.class)) {
            throw new IllegalStateException("Bean class " + declaringType + " has no LepService annotation, but have LogicExtensionPoint annotation on method: " + signature);
        }
        Method method = signature.getMethod();
        LepService lepService = declaringType.getAnnotation(LepService.class);
        LogicExtensionPoint lep = method.getAnnotation(LogicExtensionPoint.class);
        Object resultValue = lep == null && lepService.explicitMethods() ? joinPoint.proceed() : this.lepServiceHandler.onMethodInvoke(declaringType, joinPoint.getTarget(), method, joinPoint.getArgs());
        return resultValue;
    }
}

