/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.LepContextUtils;
import com.icthh.xm.commons.lep.XmLepResourceSubType;
import com.icthh.xm.commons.lep.XmLepResourceType;
import com.icthh.xm.commons.lep.storage.TenantScriptPathResolver;
import com.icthh.xm.lep.api.ContextsHolder;
import com.icthh.xm.lep.api.LepKey;
import com.icthh.xm.lep.api.LepResource;
import com.icthh.xm.lep.api.LepResourceDescriptor;
import com.icthh.xm.lep.api.LepResourceKey;
import com.icthh.xm.lep.api.LepResourceService;
import com.icthh.xm.lep.api.LepResourceType;
import com.icthh.xm.lep.api.Version;
import com.icthh.xm.lep.api.commons.DefaultLepResourceDescriptor;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import com.icthh.xm.lep.script.InputStreamSupplier;
import com.icthh.xm.lep.script.ScriptLepResource;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class XmLepResourceService
implements LepResourceService {
    private static final Logger log = LoggerFactory.getLogger(XmLepResourceService.class);
    private static final Pattern SCRIPT_TYPE_PATTERN = Pattern.compile("^.*\\Q$$\\E(.*?)\\Q.groovy\\E$");
    private final TenantScriptPathResolver tenantScriptPathResolver;
    private final String appName;
    private final ResourceLoader routerResourceLoader;

    public XmLepResourceService(String appName, TenantScriptPathResolver tenantScriptPathResolver, ResourceLoader routerResourceLoader) {
        this.appName = Objects.requireNonNull(appName, "appName can't be null");
        this.tenantScriptPathResolver = Objects.requireNonNull(tenantScriptPathResolver, "tenantScriptPathResolver can't be null");
        this.routerResourceLoader = routerResourceLoader;
    }

    public boolean isResourceExists(ContextsHolder contextsHolder, LepResourceKey resourceKey) {
        return this.getScriptResource(contextsHolder, resourceKey).exists();
    }

    public LepResourceDescriptor getResourceDescriptor(ContextsHolder contextsHolder, LepResourceKey resourceKey) {
        Objects.requireNonNull(resourceKey, "resourceKey can't be null");
        Resource scriptResource = this.getScriptResource(contextsHolder, resourceKey);
        if (!scriptResource.exists()) {
            log.debug("No LEP resource for key {}", (Object)resourceKey);
            return null;
        }
        return this.getLepResourceDescriptor(resourceKey, scriptResource);
    }

    private LepResourceDescriptor getLepResourceDescriptor(LepResourceKey resourceKey, Resource scriptResource) {
        Instant modificationTime;
        try {
            modificationTime = Instant.ofEpochMilli(scriptResource.lastModified());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while getting script resource modification time: " + e.getMessage(), e);
        }
        return new DefaultLepResourceDescriptor(XmLepResourceService.getResourceType(resourceKey), resourceKey, Instant.EPOCH, modificationTime);
    }

    private static LepResourceType getResourceType(LepResourceKey resourceKey) {
        String id = resourceKey.getId();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Resource key id cant be blank");
        }
        if (id.endsWith("groovy")) {
            return XmLepResourceType.GROOVY;
        }
        throw new IllegalStateException("Unsupported LEP resource script type for key: " + resourceKey.toString());
    }

    public LepResource getResource(ContextsHolder contextsHolder, LepResourceKey resourceKey) {
        Objects.requireNonNull(resourceKey, "resourceKey can't be null");
        log.debug("Getting LEP resource for key {}", (Object)resourceKey);
        final Resource scriptResource = this.getScriptResource(contextsHolder, resourceKey);
        if (!scriptResource.exists()) {
            log.debug("No LEP resource for key {}", (Object)resourceKey);
            return null;
        }
        LepResourceDescriptor descriptor = this.getLepResourceDescriptor(resourceKey, scriptResource);
        log.debug("LEP resource for key {} found, descriptor: {}", (Object)resourceKey, (Object)descriptor);
        return new ScriptLepResource(descriptor, ScriptLepResource.DEFAULT_ENCODING, new InputStreamSupplier(){

            public InputStream getInputStream() throws IOException {
                return scriptResource.getInputStream();
            }
        });
    }

    public LepResource saveResource(ContextsHolder contextsHolder, LepKey extensionKey, LepResource resource) {
        return null;
    }

    public List<Version> getResourceVersions(ContextsHolder contextsHolder, LepResourceKey resourceKey) {
        return Collections.emptyList();
    }

    private Resource getScriptResource(ContextsHolder contextsHolder, LepResourceKey resourceKey) {
        String location = this.getResourceLocation(contextsHolder, resourceKey);
        log.trace("LEP resource with key '{}' resolved to location '{}'", (Object)resourceKey, (Object)location);
        return this.routerResourceLoader.getResource(location);
    }

    private String getResourceLocation(ContextsHolder contextsHolder, LepResourceKey resourceKey) {
        Matcher matcher;
        if (!(resourceKey instanceof UrlLepResourceKey)) {
            throw new IllegalArgumentException("Unsupported LEP resource key type: " + resourceKey.getClass().getCanonicalName());
        }
        UrlLepResourceKey urlKey = (UrlLepResourceKey)UrlLepResourceKey.class.cast(resourceKey);
        Object path = urlKey.getUrlResourcePath();
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!(matcher = SCRIPT_TYPE_PATTERN.matcher((CharSequence)path)).find()) {
            throw new IllegalArgumentException("Can't find script type in LEP resource key: " + resourceKey);
        }
        String type = matcher.group(1);
        if (XmLepResourceSubType.DEFAULT.getName().equals(type)) {
            return this.getDefaultScriptLocation((String)path);
        }
        return this.getTenantScriptLocation((String)path, contextsHolder);
    }

    private String getDefaultScriptLocation(String path) {
        int beforeTypeIndex = path.lastIndexOf("$$");
        int scriptExtIndex = path.lastIndexOf(".");
        String pathForDefault = path.substring(0, beforeTypeIndex) + path.substring(scriptExtIndex);
        return "classpath:/lep/default" + pathForDefault;
    }

    private String getTenantScriptLocation(String path, ContextsHolder contextsHolder) {
        String tenantKey = LepContextUtils.getTenantKey(contextsHolder);
        return this.tenantScriptPathResolver.resolvePath(tenantKey, this.appName, path);
    }

    public ResourceLoader getRouterResourceLoader() {
        return this.routerResourceLoader;
    }
}

