/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.lep.CacheableLepEngine;
import com.icthh.xm.commons.lep.ClassNameLepResourceKeyMapper;
import com.icthh.xm.commons.lep.XmLepResourceKeyURLConnection;
import com.icthh.xm.lep.api.ContextsHolder;
import com.icthh.xm.lep.api.LepManagerService;
import com.icthh.xm.lep.api.LepResourceService;
import com.icthh.xm.lep.groovy.LazyGroovyScriptEngineProviderStrategy;
import com.icthh.xm.lep.groovy.LepResourceKeyURLConnection;
import com.icthh.xm.lep.groovy.LepScriptResourceConnector;
import com.icthh.xm.lep.groovy.ScriptNameLepResourceKeyMapper;
import groovy.lang.GroovyClassLoader;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import java.net.URLConnection;
import org.springframework.beans.factory.BeanClassLoaderAware;

public class XmGroovyScriptEngineProviderStrategy
extends LazyGroovyScriptEngineProviderStrategy
implements BeanClassLoaderAware,
CacheableLepEngine {
    private final ScriptNameLepResourceKeyMapper resourceKeyMapper;
    private final String appName;
    private final LepResourceService resourceService;
    private final TenantAliasService tenantAliasService;
    private volatile GroovyScriptEngine engine;
    private ClassLoader springClassLoader;

    public XmGroovyScriptEngineProviderStrategy(ScriptNameLepResourceKeyMapper resourceKeyMapper, String appName, LepResourceService resourceService, TenantAliasService tenantAliasService) {
        super(resourceKeyMapper);
        this.resourceKeyMapper = resourceKeyMapper;
        this.appName = appName;
        this.resourceService = resourceService;
        this.tenantAliasService = tenantAliasService;
    }

    protected ClassLoader getParentClassLoader() {
        return this.springClassLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.springClassLoader = classLoader;
    }

    protected ResourceConnector buildResourceConnector(final LepManagerService managerService) {
        final ClassNameLepResourceKeyMapper mapper = new ClassNameLepResourceKeyMapper(this.resourceKeyMapper, this.appName, (ContextsHolder)managerService, this.resourceService, this.tenantAliasService);
        return new LepScriptResourceConnector(managerService, mapper){

            public URLConnection getResourceConnection(String scriptName) throws ResourceException {
                try {
                    return new XmLepResourceKeyURLConnection(mapper.map(scriptName), managerService.getResourceService(), (ContextsHolder)managerService);
                }
                catch (Exception e) {
                    throw new ResourceException("Error while building " + LepResourceKeyURLConnection.class.getSimpleName() + ": " + e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    protected void initGroovyScriptEngine(GroovyScriptEngine engine, ContextsHolder contextsHolder) {
        super.initGroovyScriptEngine(engine, contextsHolder);
        this.engine = engine;
    }

    @Override
    public void clearCache() {
        GroovyScriptEngine engine = this.engine;
        if (engine != null) {
            GroovyClassLoader groovyClassLoader = engine.getGroovyClassLoader();
            groovyClassLoader.setShouldRecompile(Boolean.valueOf(true));
            groovyClassLoader.clearCache();
        }
    }
}

