/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.BaseProceedingLep;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetProceedingLep
extends BaseProceedingLep {
    private static final Logger log = LoggerFactory.getLogger(TargetProceedingLep.class);
    private final UrlLepResourceKey compositeResourceKey;

    public TargetProceedingLep(LepMethod lepMethod, UrlLepResourceKey compositeResourceKey) {
        super(lepMethod);
        this.compositeResourceKey = compositeResourceKey;
    }

    @Override
    public Object proceed() throws Exception {
        Object[] parameterTypes = this.getMethodSignature().getParameterTypes();
        if (!ArrayUtils.isEmpty((Object[])parameterTypes)) {
            throw new IllegalStateException("Call proceed without parameters on method '" + this.getMethodSignature().getName() + "' with arguments for LEP resource key:" + this.compositeResourceKey);
        }
        return this.invoke(new Object[0]);
    }

    @Override
    public Object proceed(Object[] args) throws Exception {
        Object[] parameterTypes = this.getMethodSignature().getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            throw new IllegalStateException("Call proceed with parameters on method '" + this.getMethodSignature().getName() + "' without arguments for LEP resource key: " + this.compositeResourceKey);
        }
        return this.invoke(args);
    }

    private Object invoke(Object ... args) throws Exception {
        Method method = this.getMethodSignature().getMethod();
        try {
            return method.invoke(this.getTarget(), args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error while processing target method: " + method, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IllegalStateException("Invocation exception cause is null, while processing target method for LEP resource key: " + this.compositeResourceKey);
            }
            if (cause instanceof Error) {
                throw (Error)Error.class.cast(cause);
            }
            if (cause instanceof Exception) {
                throw (Exception)Exception.class.cast(cause);
            }
            log.warn("Error execute LEP target method", (Throwable)e);
            throw new IllegalStateException("Error processing target method for LEP resource key: " + this.compositeResourceKey + ". " + cause.getMessage(), cause);
        }
    }
}

