/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.BaseProceedingLep;
import com.icthh.xm.commons.lep.LepScriptUtils;
import com.icthh.xm.lep.api.LepInvocationCauseException;
import com.icthh.xm.lep.api.LepManagerService;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import com.icthh.xm.lep.groovy.GroovyScriptRunner;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptLepResourceProceedingLep
extends BaseProceedingLep {
    private static final Logger log = LoggerFactory.getLogger(ScriptLepResourceProceedingLep.class);
    private final UrlLepResourceKey scriptResourceKey;
    private final UrlLepResourceKey compositeResourceKey;
    private final LepManagerService managerService;
    private final Supplier<GroovyScriptRunner> resourceExecutorSupplier;

    public ScriptLepResourceProceedingLep(UrlLepResourceKey compositeResourceKey, UrlLepResourceKey scriptResourceKey, LepMethod lepMethod, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier) {
        super(lepMethod);
        this.scriptResourceKey = Objects.requireNonNull(scriptResourceKey, "scriptResourceKey can't be null");
        this.compositeResourceKey = compositeResourceKey;
        this.managerService = managerService;
        this.resourceExecutorSupplier = resourceExecutorSupplier;
    }

    @Override
    public Object proceed() throws Exception {
        return this.invoke(new Object[0]);
    }

    @Override
    public Object proceed(Object[] args) throws Exception {
        return this.invoke(args);
    }

    private Object invoke(Object ... args) throws Exception {
        try {
            return LepScriptUtils.executeScript(this.scriptResourceKey, null, this, this.managerService, this.resourceExecutorSupplier, null, args);
        }
        catch (LepInvocationCauseException e) {
            log.warn("Error execute LEP {} script {}", new Object[]{this.compositeResourceKey, this.scriptResourceKey, e});
            throw e.getCause();
        }
    }
}

