/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring.web;

import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.lep.api.LepManager;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LepInterceptor
extends HandlerInterceptorAdapter {
    private final LepManager lepManager;
    private final TenantContextHolder tenantContextHolder;
    private final XmAuthenticationContextHolder xmAuthContextHolder;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        this.lepManager.beginThreadContext(scopedContext -> {
            scopedContext.setValue("tenantContext", (Object)this.tenantContextHolder.getContext());
            scopedContext.setValue("authContext", (Object)this.xmAuthContextHolder.getContext());
        });
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.lepManager.endThreadContext();
    }

    public LepInterceptor(LepManager lepManager, TenantContextHolder tenantContextHolder, XmAuthenticationContextHolder xmAuthContextHolder) {
        this.lepManager = lepManager;
        this.tenantContextHolder = tenantContextHolder;
        this.xmAuthContextHolder = xmAuthContextHolder;
    }
}

