/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.LepProcessingListenerAdapter;
import com.icthh.xm.commons.lep.spring.ApplicationLepProcessingEvent;
import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepProcessingEvent;
import com.icthh.xm.lep.api.ScopedContext;
import org.springframework.context.ApplicationListener;

public abstract class SpringLepProcessingApplicationListener
extends LepProcessingListenerAdapter
implements ApplicationListener<ApplicationLepProcessingEvent> {
    private static <T> T getRequiredValue(ScopedContext threadContext, String name, Class<T> type) {
        Object value = threadContext.getValue(name, type);
        if (value == null) {
            throw new IllegalStateException("LEP manager thread context doesn't have value for '" + name + "'");
        }
        return (T)value;
    }

    public final void onApplicationEvent(ApplicationLepProcessingEvent event) {
        LepProcessingEvent lepProcessingEvent = event.getLepProcessingEvent();
        if (lepProcessingEvent instanceof LepProcessingEvent.BeforeProcessingEvent) {
            this.onBeforeProcessingEvent((LepProcessingEvent.BeforeProcessingEvent)LepProcessingEvent.BeforeProcessingEvent.class.cast(lepProcessingEvent));
        } else if (lepProcessingEvent instanceof LepProcessingEvent.BeforeExecutionEvent) {
            this.onBeforeExecutionEvent((LepProcessingEvent.BeforeExecutionEvent)LepProcessingEvent.BeforeExecutionEvent.class.cast(lepProcessingEvent));
        } else if (lepProcessingEvent instanceof LepProcessingEvent.AfterExecutionEvent) {
            this.onAfterExecutionEvent((LepProcessingEvent.AfterExecutionEvent)LepProcessingEvent.AfterExecutionEvent.class.cast(lepProcessingEvent));
        } else if (lepProcessingEvent instanceof LepProcessingEvent.AfterProcessingEvent) {
            this.onAfterProcessingEvent((LepProcessingEvent.AfterProcessingEvent)LepProcessingEvent.AfterProcessingEvent.class.cast(lepProcessingEvent));
        } else {
            this.onOtherEvent(lepProcessingEvent);
        }
    }

    @Override
    public void onBeforeExecutionEvent(LepProcessingEvent.BeforeExecutionEvent event) {
        LepManager manager = event.getSource();
        ScopedContext threadContext = manager.getContext("lep.system.thread");
        if (threadContext == null) {
            throw new IllegalStateException("LEP manager thread context doesn't initialized");
        }
        TenantContext tenantContext = SpringLepProcessingApplicationListener.getRequiredValue(threadContext, "tenantContext", TenantContext.class);
        XmAuthenticationContext authContext = SpringLepProcessingApplicationListener.getRequiredValue(threadContext, "authContext", XmAuthenticationContext.class);
        ScopedContext executionContext = manager.getContext("lep.system.execution");
        executionContext.setValue("tenantContext", (Object)tenantContext);
        executionContext.setValue("authContext", (Object)authContext);
        this.bindExecutionContext(executionContext);
    }

    protected abstract void bindExecutionContext(ScopedContext var1);
}

