/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.XmLepLoggingExecutorListener;
import com.icthh.xm.commons.lep.spring.ApplicationLepProcessingEventPublisher;
import com.icthh.xm.lep.api.ExtensionService;
import com.icthh.xm.lep.api.LepExecutor;
import com.icthh.xm.lep.api.LepExecutorListener;
import com.icthh.xm.lep.api.LepInvocationCauseException;
import com.icthh.xm.lep.api.LepKey;
import com.icthh.xm.lep.api.LepKeyResolver;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepManagerListener;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.LepProcessingListener;
import com.icthh.xm.lep.api.LepResourceService;
import com.icthh.xm.lep.api.ScopedContext;
import com.icthh.xm.lep.api.Version;
import com.icthh.xm.lep.core.CoreLepManager;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class SpringLepManager
implements LepManager {
    private final CoreLepManager delegate = new CoreLepManager();
    private final ExtensionService extensionService;
    private final LepExecutor executor;
    private final ApplicationLepProcessingEventPublisher lepProcessingEventPublisher;
    private final LepResourceService resourceService;
    private final XmLepLoggingExecutorListener xmLepLoggingExecutorListener = new XmLepLoggingExecutorListener();

    public SpringLepManager(ExtensionService extensionService, LepExecutor executor, ApplicationLepProcessingEventPublisher lepProcessingEventPublisher, LepResourceService resourceService) {
        this.extensionService = extensionService;
        this.executor = executor;
        this.lepProcessingEventPublisher = lepProcessingEventPublisher;
        this.resourceService = resourceService;
    }

    @PostConstruct
    public void init() {
        this.init(this.extensionService, this.resourceService, this.executor);
        this.delegate.registerProcessingListener((LepProcessingListener)this.lepProcessingEventPublisher);
        this.executor.registerExecutorListener((LepExecutorListener)this.xmLepLoggingExecutorListener);
    }

    public void init(ExtensionService extensionService, LepResourceService resourceService, LepExecutor executor) {
        this.delegate.init(extensionService, resourceService, executor);
    }

    @PreDestroy
    public void destroy() {
        this.executor.unregisterExecutorListener((LepExecutorListener)this.xmLepLoggingExecutorListener);
        this.delegate.unregisterProcessingListener((LepProcessingListener)this.lepProcessingEventPublisher);
        this.delegate.destroy();
    }

    public void beginThreadContext(Consumer<? super ScopedContext> contextInitAction) {
        this.delegate.beginThreadContext(contextInitAction);
    }

    public void endThreadContext() {
        this.delegate.endThreadContext();
    }

    public Object processLep(LepKey key, Version extensionResourceVersion, LepKeyResolver keyResolver, LepMethod method) throws LepInvocationCauseException {
        return this.delegate.processLep(key, extensionResourceVersion, keyResolver, method);
    }

    public boolean registerProcessingListener(LepProcessingListener listener) {
        return this.delegate.registerProcessingListener(listener);
    }

    public boolean unregisterProcessingListener(LepProcessingListener listener) {
        return this.delegate.unregisterProcessingListener(listener);
    }

    public boolean registerLepManagerListener(LepManagerListener listener) {
        return this.delegate.registerLepManagerListener(listener);
    }

    public boolean unregisterLepManagerListener(LepManagerListener listener) {
        return this.delegate.unregisterLepManagerListener(listener);
    }

    public ExtensionService getExtensionService() {
        return this.delegate.getExtensionService();
    }

    public LepResourceService getResourceService() {
        return this.delegate.getResourceService();
    }

    public ScopedContext getContext(String scope) {
        return this.delegate.getContext(scope);
    }
}

