/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.RouterResourceLoader;
import com.icthh.xm.commons.lep.TenantScriptStorage;
import com.icthh.xm.commons.lep.XmExtensionService;
import com.icthh.xm.commons.lep.XmGroovyExecutionStrategy;
import com.icthh.xm.commons.lep.XmGroovyScriptEngineProviderStrategy;
import com.icthh.xm.commons.lep.XmLepResourceService;
import com.icthh.xm.commons.lep.XmLepScriptConfigServerResourceLoader;
import com.icthh.xm.commons.lep.spring.ApplicationLepProcessingEventPublisher;
import com.icthh.xm.commons.lep.spring.SpringLepManager;
import com.icthh.xm.lep.api.ExtensionService;
import com.icthh.xm.lep.api.LepExecutor;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepResourceService;
import com.icthh.xm.lep.groovy.DefaultScriptNameLepResourceKeyMapper;
import com.icthh.xm.lep.groovy.GroovyExecutionStrategy;
import com.icthh.xm.lep.groovy.GroovyScriptEngineProviderStrategy;
import com.icthh.xm.lep.groovy.ScriptNameLepResourceKeyMapper;
import com.icthh.xm.lep.groovy.StrategyGroovyLepExecutor;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;

@Configuration
public abstract class LepSpringConfiguration {
    private static final String FILE_URL_PREFIX = "file:";
    private static final int RESOURCE_LOADERS_CAPACITY = 3;
    private final String appName;
    private final ApplicationEventPublisher eventPublisher;
    private final ResourceLoader resourceLoader;
    @Autowired
    @Lazy
    private XmLepScriptConfigServerResourceLoader xmLepScriptConfigServerResourceLoader;

    protected LepSpringConfiguration(String appName, ApplicationEventPublisher eventPublisher, ResourceLoader resourceLoader) {
        this.appName = Objects.requireNonNull(appName);
        this.eventPublisher = eventPublisher;
        this.resourceLoader = resourceLoader;
    }

    @Bean
    @Scope(value="singleton")
    protected LepManager lepManager() {
        return new SpringLepManager(this.extensionService(), this.lepExecutor(), this.applicationLepProcessingEventPublisher(), this.lepResourceService());
    }

    @Bean
    public ScriptNameLepResourceKeyMapper scriptNameLepResourceKeyMapper() {
        return new DefaultScriptNameLepResourceKeyMapper();
    }

    @Bean
    public XmGroovyScriptEngineProviderStrategy xmGroovyScriptEngineProviderStrategy() {
        return new XmGroovyScriptEngineProviderStrategy(this.scriptNameLepResourceKeyMapper());
    }

    @Bean
    public XmGroovyExecutionStrategy xmGroovyExecutionStrategy() {
        return new XmGroovyExecutionStrategy();
    }

    @Bean
    public LepExecutor lepExecutor() {
        return new StrategyGroovyLepExecutor(this.scriptNameLepResourceKeyMapper(), (GroovyScriptEngineProviderStrategy)this.xmGroovyScriptEngineProviderStrategy(), (GroovyExecutionStrategy)this.xmGroovyExecutionStrategy());
    }

    @Bean
    public ExtensionService extensionService() {
        return new XmExtensionService();
    }

    @Bean
    public ApplicationLepProcessingEventPublisher applicationLepProcessingEventPublisher() {
        return new ApplicationLepProcessingEventPublisher(this.eventPublisher);
    }

    @Bean
    public XmLepScriptConfigServerResourceLoader cfgResourceLoader() {
        return new XmLepScriptConfigServerResourceLoader(this.appName);
    }

    @Bean
    public RouterResourceLoader routerResourceLoader() {
        HashMap<String, ResourceLoader> routerMap = new HashMap<String, ResourceLoader>(3);
        routerMap.put("classpath:", this.resourceLoader);
        routerMap.put("xm-ms-config:", this.xmLepScriptConfigServerResourceLoader);
        routerMap.put(FILE_URL_PREFIX, (ResourceLoader)new FileSystemResourceLoader());
        return new RouterResourceLoader(routerMap);
    }

    protected abstract TenantScriptStorage getTenantScriptStorageType();

    @Bean
    public LepResourceService lepResourceService() {
        return new XmLepResourceService(this.appName, this.getTenantScriptStorageType(), this.routerResourceLoader());
    }
}

