/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.spring.EnableLepServices;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.commons.lep.spring.LepServiceFactoryBean;
import com.icthh.xm.commons.lep.spring.LepServiceProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class LepServicesRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        LepServiceProvider scanner = this.getScanner();
        Set<String> basePackages = this.getBasePackages(importingClassMetadata);
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Map attributes = annotationMetadata.getAnnotationAttributes(LepService.class.getCanonicalName());
                this.registerLepService(registry, annotationMetadata, attributes);
            }
        }
    }

    private void registerLepService(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        boolean primary = (Boolean)attributes.get("primary");
        String className = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(LepServiceFactoryBean.class);
        definition.addPropertyValue("type", (Object)className);
        definition.addPropertyValue("annotationMetadata", (Object)annotationMetadata);
        definition.setAutowireMode(2);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setPrimary(primary);
        String name = LepServicesRegistrar.getBeanName(annotationMetadata, attributes);
        String alias = name + LepService.class.getSimpleName();
        String qualifier = LepServicesRegistrar.getQualifier(attributes);
        if (StringUtils.hasText((String)qualifier)) {
            alias = qualifier;
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, name, new String[]{alias});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    private static String getBeanName(AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String beanName = (String)attributes.get("value");
        if (!StringUtils.isEmpty((Object)beanName)) {
            return beanName;
        }
        String shortName = ClassUtils.getShortName((String)annotationMetadata.getClassName());
        return StringUtils.uncapitalize((String)shortName);
    }

    private static String getQualifier(Map<String, Object> lepServiceAttributes) {
        if (lepServiceAttributes == null) {
            return null;
        }
        String qualifier = (String)lepServiceAttributes.get("qualifier");
        if (StringUtils.hasText((String)qualifier)) {
            return qualifier;
        }
        return null;
    }

    private LepServiceProvider getScanner() {
        LepServiceProvider scanner = new LepServiceProvider(this.environment);
        scanner.setResourceLoader(this.resourceLoader);
        return scanner;
    }

    private Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableLepServices.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }
}

