/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.XmLepConstants;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.lep.api.LepInvocationCauseException;
import com.icthh.xm.lep.api.LepKey;
import com.icthh.xm.lep.api.LepKeyResolver;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.MethodSignature;
import com.icthh.xm.lep.api.commons.DefaultLepMethod;
import com.icthh.xm.lep.api.commons.DefaultMethodSignature;
import com.icthh.xm.lep.api.commons.SeparatorSegmentedLepKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LepServiceHandler
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LepServiceHandler.class);
    private ApplicationContext applicationContext;

    public Object onMethodInvoke(Class<?> targetType, Object target, Method method, Object[] args) throws Throwable {
        LepService typeLepService = targetType.getAnnotation(LepService.class);
        Objects.requireNonNull(typeLepService, "No " + LepService.class.getSimpleName() + " annotation for type " + targetType.getCanonicalName());
        LogicExtensionPoint methodLep = (LogicExtensionPoint)AnnotationUtils.getAnnotation((Method)method, LogicExtensionPoint.class);
        LepKeyResolver keyResolver = this.getKeyResolver(methodLep);
        LepKey baseLepKey = LepServiceHandler.getBaseLepKey(typeLepService, methodLep, method);
        LepMethod lepMethod = this.buildLepMethod(targetType, target, method, args);
        try {
            return this.getLepManager().processLep(baseLepKey, XmLepConstants.UNUSED_RESOURCE_VERSION, keyResolver, lepMethod);
        }
        catch (LepInvocationCauseException e) {
            log.debug("Error process target", (Throwable)e);
            throw e.getCause();
        }
        catch (Exception e) {
            throw e;
        }
    }

    private LepMethod buildLepMethod(Class<?> targetType, Object target, Method method, Object[] args) {
        String[] parameterNames;
        DefaultMethodSignature signature = new DefaultMethodSignature();
        signature.setName(method.getName());
        signature.setModifiers(method.getModifiers());
        signature.setDeclaringClass(targetType);
        signature.setParameterTypes((Class[])method.getParameterTypes());
        signature.setExceptionTypes((Class[])method.getExceptionTypes());
        signature.setReturnType(method.getReturnType());
        signature.setMethod(method);
        Parameter[] parameters = method.getParameters();
        if (parameters == null) {
            parameterNames = new String[]{};
        } else {
            parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter p = parameters[i];
                parameterNames[i] = p.getName();
            }
        }
        signature.setParameterNames(parameterNames);
        return new DefaultLepMethod(target, (MethodSignature)signature, args);
    }

    private static LepKey getBaseLepKey(LepService typeLepService, LogicExtensionPoint methodLep, Method method) {
        String keyName;
        String groupName;
        Map lepServiceAttrs = AnnotationUtils.getAnnotationAttributes((Annotation)typeLepService);
        String globalGroupName = (String)lepServiceAttrs.get("group");
        if (methodLep == null) {
            groupName = globalGroupName;
            keyName = method.getName();
        } else {
            Map lepAttrs = AnnotationUtils.getAnnotationAttributes((Annotation)methodLep);
            String lepGroupName = (String)lepAttrs.get("group");
            groupName = StringUtils.isEmpty((Object)lepGroupName) || lepGroupName.trim().isEmpty() ? globalGroupName : lepGroupName;
            keyName = (String)lepAttrs.get("value");
        }
        if (keyName != null && keyName.contains(".")) {
            throw new IllegalArgumentException("Key name '" + keyName + "' can't contains segments separator: '" + "." + "'");
        }
        String segments = groupName + "." + keyName;
        return new SeparatorSegmentedLepKey(segments, ".", XmLepConstants.EXTENSION_KEY_GROUP_MODE);
    }

    private LepKeyResolver getKeyResolver(LogicExtensionPoint lep) {
        if (lep == null) {
            return null;
        }
        Class<? extends LepKeyResolver> keyResolverClass = lep.resolver();
        if (LepKeyResolver.class.equals(keyResolverClass)) {
            return null;
        }
        return (LepKeyResolver)this.applicationContext.getBean(keyResolverClass);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private LepManager getLepManager() {
        return (LepManager)this.applicationContext.getBean(LepManager.class);
    }
}

