/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.XmLepResourceSubType;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import java.util.Set;

public final class XmLepScriptRules {
    private static final byte BEFORE_MASK = 32;
    private static final byte AROUND_MASK = 16;
    private static final byte TENANT_MASK = 8;
    private static final byte DEFAULT_MASK = 4;
    private static final byte JAVA_CODE_MASK = 2;
    private static final byte AFTER_MASK = 1;
    private static final byte ZERO_PATTERN_NO_TENANT_AND_DEFAULT_AND_JAVA_CODE = 14;
    private static final byte IS_SET_PATTERN_AROUND_AND_BEFORE = 48;
    private static final byte IS_SET_PATTERN_AROUND_AND_AFTER = 17;
    private static final byte IS_SET_PATTERN_AROUND_AND_TENANT = 24;

    public static void validateScriptsCombination(Set<XmLepResourceSubType> scriptTypes, LepMethod lepMethod, UrlLepResourceKey compositeResourceKey) {
        byte mask = XmLepScriptRules.getCombinationMask(scriptTypes, lepMethod, compositeResourceKey);
        StringBuilder errors = new StringBuilder();
        if (XmLepScriptRules.isZero(mask, (byte)14)) {
            errors.append(String.format("Has no one script of '%s', '%s' or native (java) implementation.", new Object[]{XmLepResourceSubType.TENANT, XmLepResourceSubType.DEFAULT}));
        }
        if (XmLepScriptRules.isSetByPattern(mask, (byte)48)) {
            if (errors.length() > 0) {
                errors.append(" ");
            }
            errors.append(String.format("Has '%s' script with '%s'.", new Object[]{XmLepResourceSubType.BEFORE, XmLepResourceSubType.AROUND}));
        }
        if (XmLepScriptRules.isSetByPattern(mask, (byte)17)) {
            if (errors.length() > 0) {
                errors.append(" ");
            }
            errors.append(String.format("Has '%s' script with '%s'.", new Object[]{XmLepResourceSubType.AROUND, XmLepResourceSubType.AFTER}));
        }
        if (XmLepScriptRules.isSetByPattern(mask, (byte)24)) {
            if (errors.length() > 0) {
                errors.append(" ");
            }
            errors.append(String.format("Unallowed combination '%s' and '%s' scripts.", new Object[]{XmLepResourceSubType.AROUND, XmLepResourceSubType.TENANT}));
        }
        if (errors.length() > 0) {
            throw new IllegalArgumentException(String.format("Resource key %s has script combination errors. %s", compositeResourceKey, errors.toString()));
        }
    }

    private static boolean isZero(byte value, byte pattern) {
        return (value & pattern) == 0;
    }

    private static boolean isSetByPattern(byte value, byte pattern) {
        return (value & pattern) == pattern;
    }

    private static byte getCombinationMask(Set<XmLepResourceSubType> scriptTypes, LepMethod lepMethod, UrlLepResourceKey compositeResourceKey) {
        byte combinationMask = 0;
        block7: for (XmLepResourceSubType scriptType : scriptTypes) {
            switch (scriptType) {
                case BEFORE: {
                    combinationMask = (byte)(combinationMask | 0x20);
                    continue block7;
                }
                case AROUND: {
                    combinationMask = (byte)(combinationMask | 0x10);
                    continue block7;
                }
                case TENANT: {
                    combinationMask = (byte)(combinationMask | 8);
                    continue block7;
                }
                case DEFAULT: {
                    combinationMask = (byte)(combinationMask | 4);
                    continue block7;
                }
                case AFTER: {
                    combinationMask = (byte)(combinationMask | 1);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unsupported script type: " + (Object)((Object)scriptType) + " for resource key: " + compositeResourceKey + ", all script types: " + scriptTypes);
        }
        if (lepMethod.getTarget() != null) {
            combinationMask = (byte)(combinationMask | 2);
        }
        return combinationMask;
    }

    private XmLepScriptRules() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

