/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.lep.XmLepScriptResource;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;

public class XmLepScriptConfigServerResourceLoader
implements RefreshableConfiguration,
ResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmLepScriptConfigServerResourceLoader.class);
    public static final String XM_MS_CONFIG_URL_PREFIX = "xm-ms-config:";
    private final String tenantLepScriptsAntPathPattern;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private ConcurrentHashMap<String, XmLepScriptResource> scriptResources = new ConcurrentHashMap();

    public XmLepScriptConfigServerResourceLoader(String appName) {
        Objects.requireNonNull(appName, "appName can't be null");
        this.tenantLepScriptsAntPathPattern = "/config/tenants/{tenantKey}/" + appName + "/lep/**";
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.pathMatcher.match(this.tenantLepScriptsAntPathPattern, updatedKey);
    }

    public void onInit(String configKey, String configContent) {
        String scriptContent = configContent == null ? "" : configContent;
        XmLepScriptResource resource = new XmLepScriptResource(configKey, scriptContent, XmLepScriptConfigServerResourceLoader.getCurrentMilli());
        LOGGER.info("LEP xm-ms-config file inited by config path: {}", (Object)configKey);
        this.scriptResources.put(configKey, resource);
    }

    public void onRefresh(String updatedKey, String configContent) {
        boolean isDeleted;
        boolean bl = isDeleted = configContent == null;
        if (isDeleted) {
            LOGGER.info("LEP script deleted by config path: {}", (Object)updatedKey);
            this.scriptResources.remove(updatedKey);
        } else {
            this.scriptResources.compute(updatedKey, (key, currentValue) -> {
                if (currentValue != null) {
                    LOGGER.info("LEP script updated by config path: {}", (Object)updatedKey);
                    currentValue.update(configContent, XmLepScriptConfigServerResourceLoader.getCurrentMilli());
                    return currentValue;
                }
                LOGGER.info("LEP script created by config path: {}", (Object)updatedKey);
                return new XmLepScriptResource(updatedKey, configContent, XmLepScriptConfigServerResourceLoader.getCurrentMilli());
            });
        }
    }

    private static long getCurrentMilli() {
        return Instant.now().toEpochMilli();
    }

    public Resource getResource(String location) {
        String cfgPath = StringUtils.removeStart((String)location, (String)XM_MS_CONFIG_URL_PREFIX);
        return (Resource)this.scriptResources.getOrDefault(cfgPath, XmLepScriptResource.nonExist());
    }

    public ClassLoader getClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }
}

