/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import com.icthh.xm.lep.api.LepExecutorEvent;
import com.icthh.xm.lep.api.LepExecutorListener;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.MethodSignature;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmLepLoggingExecutorListener
implements LepExecutorListener {
    private static final Logger log = LoggerFactory.getLogger(XmLepLoggingExecutorListener.class);
    private static final String LOG_QUESTION = "?";
    private static final String LOG_SEMICOLON = ":";

    public void accept(LepExecutorEvent lepExecutorEvent) {
        if (lepExecutorEvent instanceof LepExecutorEvent.BeforeResourceExecutionEvent) {
            this.onBeforeEvent((LepExecutorEvent.BeforeResourceExecutionEvent)lepExecutorEvent);
        } else if (lepExecutorEvent instanceof LepExecutorEvent.AfterResourceExecutionEvent) {
            this.onAfterEvent((LepExecutorEvent.AfterResourceExecutionEvent)lepExecutorEvent);
        }
    }

    private void onBeforeEvent(LepExecutorEvent.BeforeResourceExecutionEvent beforeEvent) {
        log.info("lep:start: execute lep at [{}], script: {}", (Object)XmLepLoggingExecutorListener.buildLepSignature(beforeEvent.getMethod()), (Object)beforeEvent.getKey());
    }

    private void onAfterEvent(LepExecutorEvent.AfterResourceExecutionEvent afterEvent) {
        String signatureToPrint = XmLepLoggingExecutorListener.buildLepSignature(afterEvent.getMethod());
        String scriptName = afterEvent.getKey().getId();
        Optional exception = afterEvent.getResult().flatMap(LepExecutorEvent.ResultObject::getException);
        if (exception.isPresent()) {
            this.logStopError(signatureToPrint, scriptName, (Exception)exception.get());
        } else {
            this.logStop(signatureToPrint, scriptName);
        }
    }

    private void logStop(String signature, String scriptName) {
        log.info("lep:stop:  execute lep at [{}], script: {}", (Object)signature, (Object)scriptName);
    }

    private void logStopError(String signature, String scriptName, Exception e) {
        log.error("lep:stop:  execute lep error at [{}], script: {}, error: {}", new Object[]{signature, scriptName, LogObjectPrinter.printExceptionWithStackInfo((Throwable)e)});
    }

    private static String buildLepSignature(LepMethod method) {
        String className = Optional.ofNullable(method).map(LepMethod::getMethodSignature).map(MethodSignature::getDeclaringClass).map(Class::getSimpleName).orElse(LOG_QUESTION);
        String methodName = Optional.ofNullable(method).map(LepMethod::getMethodSignature).map(MethodSignature::getName).orElse(LOG_QUESTION);
        return className + LOG_SEMICOLON + methodName;
    }
}

