/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.LepContextUtils;
import com.icthh.xm.commons.lep.LepMethodResult;
import com.icthh.xm.commons.lep.LepScriptUtils;
import com.icthh.xm.commons.lep.MethodResultProcessor;
import com.icthh.xm.commons.lep.ProceedingLep;
import com.icthh.xm.commons.lep.ScriptLepResourceProceedingLep;
import com.icthh.xm.commons.lep.TargetProceedingLep;
import com.icthh.xm.commons.lep.XmLepResourceSubType;
import com.icthh.xm.commons.lep.XmLepScriptRules;
import com.icthh.xm.lep.api.ContextsHolder;
import com.icthh.xm.lep.api.LepInvocationCauseException;
import com.icthh.xm.lep.api.LepManagerService;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.LepResourceKey;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import com.icthh.xm.lep.groovy.GroovyExecutionStrategy;
import com.icthh.xm.lep.groovy.GroovyScriptRunner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmGroovyExecutionStrategy
implements GroovyExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(XmGroovyExecutionStrategy.class);

    public Object executeLepResource(UrlLepResourceKey compositeResourceKey, LepMethod method, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier) throws LepInvocationCauseException {
        Map<XmLepResourceSubType, UrlLepResourceKey> atomicResourceKeys = this.getAvailableAtomicResourceKeys(compositeResourceKey, managerService);
        XmLepScriptRules.validateScriptsCombination(atomicResourceKeys.keySet(), method, compositeResourceKey);
        if (atomicResourceKeys.isEmpty()) {
            return XmGroovyExecutionStrategy.onNoScripts(compositeResourceKey, method);
        }
        if (atomicResourceKeys.containsKey((Object)XmLepResourceSubType.AROUND)) {
            return this.onAroundScript(compositeResourceKey, atomicResourceKeys, method, managerService, resourceExecutorSupplier);
        }
        return this.onWithoutAroundScript(compositeResourceKey, atomicResourceKeys, method, managerService, resourceExecutorSupplier);
    }

    private static Object onNoScripts(UrlLepResourceKey compositeResourceKey, LepMethod method) throws LepInvocationCauseException {
        Object target = method.getTarget();
        if (target == null) {
            throw new IllegalStateException(String.format("LEP resource key %s has no defined script(s) and target object. Possible LEP defined in interface and has no default script provided.", compositeResourceKey));
        }
        return XmGroovyExecutionStrategy.executeLepTargetMethod(compositeResourceKey, method, target).processResult();
    }

    private static MethodResultProcessor executeLepTargetMethod(UrlLepResourceKey compositeResourceKey, LepMethod method, Object target) throws LepInvocationCauseException {
        Method jvmMethod = method.getMethodSignature().getMethod();
        try {
            return MethodResultProcessor.valueOf(jvmMethod.invoke(target, method.getMethodArgValues()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error invoking target method for LEP resource key: " + compositeResourceKey + ". " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            LepInvocationCauseException methodException;
            log.info("Exception while invoking target method for LEP resource key: {}", (Object)compositeResourceKey, (Object)e);
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IllegalStateException("Null cause while invoking target method for LEP resource key: " + compositeResourceKey);
            }
            if (cause instanceof Error) {
                throw (Error)Error.class.cast(cause);
            }
            if (cause instanceof Exception) {
                methodException = new LepInvocationCauseException((Exception)cause);
            } else {
                IllegalStateException ex = new IllegalStateException("Error invoking target method for LEP resource key: " + compositeResourceKey + ". " + cause.getMessage(), cause);
                methodException = new LepInvocationCauseException((Exception)ex);
            }
            return MethodResultProcessor.valueOf(methodException);
        }
    }

    private Object onAroundScript(UrlLepResourceKey compositeResourceKey, Map<XmLepResourceSubType, UrlLepResourceKey> atomicResourceKeys, LepMethod method, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier) throws LepInvocationCauseException {
        UrlLepResourceKey aroundKey = atomicResourceKeys.get((Object)XmLepResourceSubType.AROUND);
        UrlLepResourceKey defaultKey = atomicResourceKeys.get((Object)XmLepResourceSubType.DEFAULT);
        ProceedingLep proceedingLep = XmGroovyExecutionStrategy.buildProceedingLep(compositeResourceKey, defaultKey, method, managerService, resourceExecutorSupplier);
        return LepScriptUtils.executeScript(aroundKey, proceedingLep, method, managerService, resourceExecutorSupplier, null, new Object[0]);
    }

    private Object onWithoutAroundScript(UrlLepResourceKey compositeResourceKey, Map<XmLepResourceSubType, UrlLepResourceKey> atomicResourceKeys, LepMethod method, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier) throws LepInvocationCauseException {
        Object target = method.getTarget();
        this.executeBeforeIfExists(atomicResourceKeys, method, managerService, resourceExecutorSupplier);
        MethodResultProcessor methodResultProcessor = atomicResourceKeys.containsKey((Object)XmLepResourceSubType.TENANT) ? XmGroovyExecutionStrategy.executeLepScript(atomicResourceKeys, method, managerService, resourceExecutorSupplier, XmLepResourceSubType.TENANT) : (atomicResourceKeys.containsKey((Object)XmLepResourceSubType.DEFAULT) ? XmGroovyExecutionStrategy.executeLepScript(atomicResourceKeys, method, managerService, resourceExecutorSupplier, XmLepResourceSubType.DEFAULT) : XmGroovyExecutionStrategy.executeLepTargetMethod(compositeResourceKey, method, target));
        methodResultProcessor = XmGroovyExecutionStrategy.executeAfterScriptIfExists(atomicResourceKeys, method, managerService, resourceExecutorSupplier, methodResultProcessor);
        return methodResultProcessor.processResult();
    }

    private void executeBeforeIfExists(Map<XmLepResourceSubType, UrlLepResourceKey> atomicResourceKeys, LepMethod method, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier) throws LepInvocationCauseException {
        if (atomicResourceKeys.containsKey((Object)XmLepResourceSubType.BEFORE)) {
            UrlLepResourceKey beforeKey = atomicResourceKeys.get((Object)XmLepResourceSubType.BEFORE);
            LepScriptUtils.executeScript(beforeKey, null, method, managerService, resourceExecutorSupplier, null, new Object[0]);
        }
    }

    private static MethodResultProcessor executeAfterScriptIfExists(Map<XmLepResourceSubType, UrlLepResourceKey> atomicResourceKeys, LepMethod method, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier, MethodResultProcessor methodResultProcessor) {
        if (!atomicResourceKeys.containsKey((Object)XmLepResourceSubType.AFTER)) {
            return methodResultProcessor;
        }
        if (methodResultProcessor.isError()) {
            return methodResultProcessor;
        }
        UrlLepResourceKey afterKey = atomicResourceKeys.get((Object)XmLepResourceSubType.AFTER);
        try {
            LepScriptUtils.executeScript(afterKey, null, method, managerService, resourceExecutorSupplier, LepMethodResult.valueOf(methodResultProcessor), new Object[0]);
        }
        catch (LepInvocationCauseException e) {
            return MethodResultProcessor.valueOf(e);
        }
        return methodResultProcessor;
    }

    private static MethodResultProcessor executeLepScript(Map<XmLepResourceSubType, UrlLepResourceKey> atomicResourceKeys, LepMethod method, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier, XmLepResourceSubType key) {
        try {
            Object value = LepScriptUtils.executeScript(atomicResourceKeys.get((Object)key), null, method, managerService, resourceExecutorSupplier, null, new Object[0]);
            return MethodResultProcessor.valueOf(value);
        }
        catch (LepInvocationCauseException e) {
            return MethodResultProcessor.valueOf(e);
        }
    }

    private static ProceedingLep buildProceedingLep(UrlLepResourceKey compositeResourceKey, UrlLepResourceKey defaultKey, LepMethod lepMethod, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier) {
        if (defaultKey != null) {
            return new ScriptLepResourceProceedingLep(compositeResourceKey, defaultKey, lepMethod, managerService, resourceExecutorSupplier);
        }
        if (lepMethod.getTarget() != null) {
            return new TargetProceedingLep(lepMethod, compositeResourceKey);
        }
        throw new IllegalArgumentException("Resource key " + compositeResourceKey + " has defaultKey and target object both null, what is inadmissible");
    }

    public Map<XmLepResourceSubType, UrlLepResourceKey> getAvailableAtomicResourceKeys(UrlLepResourceKey compositeResourceKey, LepManagerService managerService) {
        int extIndex;
        String compositePath = compositeResourceKey.getUrlResourcePath();
        if (!compositePath.startsWith("/")) {
            compositePath = "/" + compositePath;
        }
        if ((extIndex = compositePath.lastIndexOf(".")) <= 0) {
            throw new IllegalArgumentException("LEP resource name must ends with *.<extension>, actual value: " + compositePath);
        }
        String scriptBasePath = compositePath.substring(0, extIndex);
        String extension = compositePath.substring(extIndex);
        String tenantKey = LepContextUtils.getTenantKey((ContextsHolder)managerService);
        EnumMap<XmLepResourceSubType, UrlLepResourceKey> resourceKeyMap = new EnumMap<XmLepResourceSubType, UrlLepResourceKey>(XmLepResourceSubType.class);
        for (XmLepResourceSubType type : XmLepResourceSubType.values()) {
            String resourceUrlPath = "//" + tenantKey + scriptBasePath + "$$" + type.getName() + extension;
            UrlLepResourceKey atomicKey = UrlLepResourceKey.valueOfUrlResourcePath((String)resourceUrlPath);
            if (!managerService.getResourceService().isResourceExists((ContextsHolder)managerService, (LepResourceKey)atomicKey)) continue;
            resourceKeyMap.put(type, atomicKey);
        }
        return resourceKeyMap;
    }
}

