/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.MethodResultProcessor;
import com.icthh.xm.lep.api.LepInvocationCauseException;
import java.util.Optional;

public class LepMethodResult {
    private final Object returnedValue;
    private final LepInvocationCauseException lepInvocationCauseException;

    private LepMethodResult(Object returnedValue, LepInvocationCauseException lepInvocationCauseException) {
        if (returnedValue != null && lepInvocationCauseException != null) {
            throw new IllegalArgumentException("returned value and lep exception can't both be not null");
        }
        this.returnedValue = returnedValue;
        this.lepInvocationCauseException = lepInvocationCauseException;
    }

    public static LepMethodResult valueOf(Object methodResult) {
        return new LepMethodResult(methodResult, null);
    }

    public static LepMethodResult valueOf(LepInvocationCauseException methodException) {
        return new LepMethodResult(null, methodException);
    }

    public static LepMethodResult valueOf(MethodResultProcessor methodResultProcessor) {
        if (methodResultProcessor.isError()) {
            return LepMethodResult.valueOf(methodResultProcessor.getLepInvocationCauseException());
        }
        return LepMethodResult.valueOf(methodResultProcessor.getReturnedValue());
    }

    public Optional<Object> getReturnedValue() {
        return Optional.ofNullable(this.returnedValue);
    }

    public boolean isError() {
        return this.lepInvocationCauseException != null;
    }
}

