/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.processor;

import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.processor.GroovyMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.icthh.xm.commons.lep.processor.GroovyMap"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class GroovyMapWrapperProcessor
extends AbstractProcessor {
    private Types typeUtils;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
    }

    private Set<String> listFields(TypeElement typeElement) {
        HashSet<String> fields = new HashSet<String>();
        while (typeElement != null && !this.isObjectClass(typeElement)) {
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC)) continue;
                fields.add(element.getSimpleName().toString());
            }
            TypeMirror superclass = typeElement.getSuperclass();
            typeElement = (TypeElement)this.typeUtils.asElement(superclass);
        }
        return fields;
    }

    private boolean isObjectClass(TypeElement typeElement) {
        return typeElement.toString().equals(Object.class.getCanonicalName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(GroovyMap.class)) {
            if (!(element instanceof TypeElement)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can only be applied to class.");
                return true;
            }
            TypeElement baseElement = (TypeElement)element;
            String packageName = this.processingEnv.getElementUtils().getPackageOf(baseElement).getQualifiedName().toString();
            ClassName baseClassName = ClassName.get((String)packageName, (String)baseElement.getSimpleName().toString(), (String[])new String[0]);
            TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)"GroovyMapLepContextWrapper").addSuperinterface((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class})).superclass((TypeName)baseClassName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
            Set<String> fields = this.listFields(baseElement);
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addParameter(BaseLepContext.class, "baseLepContext", new javax.lang.model.element.Modifier[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
            constructorBuilder.addStatement("$L lepContext = ($L)baseLepContext", new Object[]{baseClassName, baseClassName});
            fields.forEach(field -> constructorBuilder.addStatement("this.$L = lepContext.$L", new Object[]{field, field}));
            constructorBuilder.addStatement("lepContext.setAdditionalContextTo(this)", new Object[0]);
            MethodSpec constructor = constructorBuilder.build();
            classBuilder.addMethod(constructor);
            MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).returns(Object.class).addParameter(Object.class, "key", new javax.lang.model.element.Modifier[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).beginControlFlow("switch (key.toString())", new Object[0]);
            fields.forEach(field -> getMethodBuilder.addCode("case \"$L\": return this.$L;\n", new Object[]{field, field}));
            classBuilder.addMethod(getMethodBuilder.addCode("default: return this.getAdditionalContext(key.toString());\n", new Object[0]).endControlFlow().build());
            MethodSpec.Builder containsKeyMethodBuilder = MethodSpec.methodBuilder((String)"containsKey").addAnnotation(Override.class).returns(Boolean.TYPE).addParameter(Object.class, "key", new javax.lang.model.element.Modifier[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).beginControlFlow("switch (key.toString())", new Object[0]);
            fields.forEach(field -> containsKeyMethodBuilder.addCode("case \"$L\": return true;\n", new Object[]{field}));
            classBuilder.addMethod(containsKeyMethodBuilder.addCode("default: return this.getAdditionalContext(key.toString()) != null;\n", new Object[0]).endControlFlow().build());
            Method[] methods = Map.class.getMethods();
            Arrays.stream(methods).filter(Predicate.not(Method::isDefault)).filter(it -> !Modifier.isStatic(it.getModifiers())).filter(it -> !"get".equals(it.getName())).filter(it -> !"containsKey".equals(it.getName())).filter(it -> !"put".equals(it.getName())).forEach(method -> {
                MethodSpec.Builder builder = MethodSpec.methodBuilder((String)method.getName()).addAnnotation(Override.class).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).returns(method.getReturnType());
                Arrays.stream(method.getParameters()).forEach(param -> builder.addParameter(param.getType(), param.getName(), new javax.lang.model.element.Modifier[0]));
                MethodSpec methodSpec = builder.addStatement("throw new UnsupportedOperationException(\"Not implemented\")", new Object[0]).build();
                classBuilder.addMethod(methodSpec);
            });
            MethodSpec putMethod = MethodSpec.methodBuilder((String)"put").addAnnotation(Override.class).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).returns(Object.class).addParameter(String.class, "key", new javax.lang.model.element.Modifier[0]).addParameter(Object.class, "value", new javax.lang.model.element.Modifier[0]).addStatement("throw new UnsupportedOperationException(\"Not implemented\")", new Object[0]).build();
            classBuilder.addMethod(putMethod);
            JavaFile javaFile = JavaFile.builder((String)"com.icthh.xm.commons", (TypeSpec)classBuilder.build()).build();
            try {
                javaFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write generated class: " + e.getMessage());
            }
        }
        return true;
    }
}

