/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.exceptions.BusinessException;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonValidationUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonValidationUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V4);

    public static Set<ValidationMessage> validateJson(Map<String, Object> data, JsonSchema schema) {
        Set<ValidationMessage> errors = JsonValidationUtils.validate(data, schema);
        if (!errors.isEmpty()) {
            log.error("Validation data report: {}", (Object)JsonValidationUtils.getReportErrorMessage(errors));
        }
        return errors;
    }

    public static void assertJson(Map<String, Object> data, String jsonSchema) {
        JsonSchema schema = factory.getSchema(jsonSchema);
        Set<ValidationMessage> errors = JsonValidationUtils.validate(data, schema);
        if (!errors.isEmpty()) {
            String message = JsonValidationUtils.getReportErrorMessage(errors);
            log.error("Validation data report: {}", (Object)message);
            throw new InvalidJsonException(message);
        }
    }

    private static String getReportErrorMessage(Set<ValidationMessage> report) {
        return report.stream().map(ValidationMessage::getMessage).collect(Collectors.joining(" | "));
    }

    private static Set<ValidationMessage> validate(Map<String, Object> data, JsonSchema jsonSchema) {
        log.debug("Validation data. map: {}", data);
        JsonNode dataNode = objectMapper.valueToTree(data);
        return jsonSchema.validate(dataNode);
    }

    private JsonValidationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class InvalidJsonException
    extends BusinessException {
        public InvalidJsonException(String message) {
            super("error.validation.data.spec", message);
        }
    }
}

