/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.rest;

import com.codahale.metrics.annotation.Timed;
import com.icthh.xm.commons.domain.FunctionResult;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.service.FunctionServiceFacade;
import com.icthh.xm.commons.utils.HttpRequestUtils;
import com.icthh.xm.commons.utils.ModelAndViewUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api"})
public class FunctionMvcResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionMvcResource.class);
    private final FunctionServiceFacade functionService;
    private FunctionMvcResource self;

    @Autowired
    public void setSelf(@Lazy FunctionMvcResource self) {
        this.self = self;
    }

    @Timed
    @PostMapping(value={"/functions/mvc/{functionKey:.+}"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.MVC.CALL')")
    @PrivilegeDescription(value="Privilege to execute a mvc function by key (key in entity specification)")
    public ModelAndView callMvcFunction(@PathVariable(value="functionKey") String functionKey, @RequestBody(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.execute(functionKey, functionInput, HttpMethod.POST.name());
        return ModelAndViewUtils.getMvcResult(result);
    }

    @Timed
    @PostMapping(value={"/functions/mvc/{functionKey:.+}"}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.MVC.CALL')")
    @PrivilegeDescription(value="Privilege to execute a mvc function by key (key in entity specification)")
    public ModelAndView callPostFormMvcFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam(required=false) Map<String, Object> functionInput) {
        return this.callMvcFunction(functionKey, functionInput);
    }

    @Timed
    @PostMapping(value={"/functions/anonymous/mvc/{functionKey:.+}"})
    public ModelAndView callMvcAnonymousFunction(@PathVariable(value="functionKey") String functionKey, @RequestBody(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.executeAnonymous(functionKey, functionInput, HttpMethod.POST.name());
        return ModelAndViewUtils.getMvcResult(result);
    }

    @Timed
    @GetMapping(value={"/functions/anonymous/mvc/{functionKey:.+}"})
    public ModelAndView callMvcGetAnonymousFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.executeAnonymous(functionKey, functionInput, HttpMethod.GET.name());
        return ModelAndViewUtils.getMvcResult(result);
    }

    @Timed
    @PostMapping(value={"/functions/anonymous/mvc/{functionKey:.+}"}, consumes={"application/x-www-form-urlencoded"})
    public ModelAndView callPostFormMvcAnonymousFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.executeAnonymous(functionKey, functionInput, "POST_URLENCODED");
        return ModelAndViewUtils.getMvcResult(result);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/mvc/**"})
    public ModelAndView callMvcFunction(HttpServletRequest request, @RequestBody(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callMvcFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/mvc/**"}, consumes={"application/x-www-form-urlencoded"})
    public ModelAndView callPostFormMvcFunction(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callMvcFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @GetMapping(value={"/functions/anonymous/mvc/**"})
    public ModelAndView callMvcAnonymousGetFunction(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callMvcGetAnonymousFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/anonymous/mvc/**"})
    public ModelAndView callMvcAnonymousFunction(HttpServletRequest request, @RequestBody(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callMvcAnonymousFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/anonymous/mvc/**"}, consumes={"application/x-www-form-urlencoded"})
    public ModelAndView callPostFromMvcAnonymousFunction(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callMvcAnonymousFunction(functionKey, functionInput);
    }

    public FunctionMvcResource(FunctionServiceFacade functionService) {
        this.functionService = functionService;
    }
}

