/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.rest;

import com.codahale.metrics.annotation.Timed;
import com.icthh.xm.commons.domain.FunctionResult;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.service.FunctionServiceFacade;
import com.icthh.xm.commons.utils.HttpRequestUtils;
import com.icthh.xm.commons.utils.ResponseEntityUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class FunctionResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionResource.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    private final FunctionServiceFacade functionService;
    private FunctionResource self;

    @Autowired
    public void setSelf(@Lazy FunctionResource self) {
        this.self = self;
    }

    @Timed
    @GetMapping(value={"/functions/{functionKey:.+}"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.GET.CALL')")
    @PrivilegeDescription(value="Privilege to call get function")
    public ResponseEntity<Object> callGetFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.execute(functionKey, functionInput, HttpMethod.GET.name());
        return ResponseEntity.ok().body(result.functionResult());
    }

    @Timed
    @PutMapping(value={"/functions/{functionKey:.+}"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.PUT.CALL')")
    @PrivilegeDescription(value="Privilege to call put function")
    public ResponseEntity<Object> callPutFunction(@PathVariable(value="functionKey") String functionKey, @RequestBody(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.execute(functionKey, functionInput, HttpMethod.PUT.name());
        return ResponseEntity.ok().body(result.functionResult());
    }

    @Timed
    @PatchMapping(value={"/functions/{functionKey:.+}"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.PATCH.CALL')")
    @PrivilegeDescription(value="Privilege to call patch function")
    public ResponseEntity<Object> callPatchFunction(@PathVariable(value="functionKey") String functionKey, @RequestBody(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.execute(functionKey, functionInput, HttpMethod.PATCH.name());
        return ResponseEntity.ok().body(result.functionResult());
    }

    @Timed
    @PostMapping(value={"/functions/{functionKey:.+}"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.CALL')")
    @PrivilegeDescription(value="Privilege to execute a function by specification key")
    public ResponseEntity<Object> callPostFunction(@PathVariable(value="functionKey") String functionKey, @RequestBody(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.execute(functionKey, functionInput, HttpMethod.POST.name());
        return ResponseEntityUtils.processCreatedResponse(this.applicationName, result);
    }

    @Timed
    @PostMapping(value={"/functions/{functionKey:.+}"}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.CALL')")
    @PrivilegeDescription(value="Privilege to execute a function by key (key in entity specification)")
    public ResponseEntity<Object> callPostFormFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.execute(functionKey, functionInput, "POST_URLENCODED");
        return ResponseEntityUtils.processCreatedResponse(this.applicationName, result);
    }

    @Timed
    @DeleteMapping(value={"/functions/{functionKey:.+}"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.DELETE.CALL')")
    @PrivilegeDescription(value="Privilege to execute a function by key (key in entity specification)")
    public ResponseEntity<Object> callDeleteFunction(@PathVariable(value="functionKey") String functionKey, @RequestBody(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.execute(functionKey, functionInput, HttpMethod.DELETE.name());
        return ResponseEntity.ok().body(result.functionResult());
    }

    @Timed
    @PostMapping(value={"/functions/anonymous/{functionKey:.+}"})
    public ResponseEntity<Object> callPostAnonymousFunction(@PathVariable(value="functionKey") String functionKey, @RequestBody(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.executeAnonymous(functionKey, functionInput, HttpMethod.POST.name());
        return ResponseEntityUtils.processCreatedResponse(this.applicationName, result);
    }

    @Timed
    @PostMapping(value={"/functions/anonymous/{functionKey:.+}"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Object> callPostFormAnonymousFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.executeAnonymous(functionKey, functionInput, "POST_URLENCODED");
        return ResponseEntityUtils.processCreatedResponse(this.applicationName, result);
    }

    @Timed
    @GetMapping(value={"/functions/anonymous/{functionKey:.+}"})
    public ResponseEntity<Object> callGetAnonymousFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam(required=false) Map<String, Object> functionInput) {
        FunctionResult result = this.functionService.executeAnonymous(functionKey, functionInput, HttpMethod.GET.name());
        return ResponseEntity.ok().body(result.functionResult());
    }

    @IgnoreLogginAspect
    @Timed
    @GetMapping(value={"/functions/**"})
    public ResponseEntity<Object> callGetFunction(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callGetFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/**"})
    public ResponseEntity<Object> callPostFunction(HttpServletRequest request, @RequestBody(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callPostFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/**"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Object> callPostFormFunction(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callPostFormFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PutMapping(value={"/functions/**"})
    public ResponseEntity<Object> callPutFunction(HttpServletRequest request, @RequestBody(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callPutFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PatchMapping(value={"/functions/**"})
    public ResponseEntity<Object> callPatchFunction(HttpServletRequest request, @RequestBody(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callPatchFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @DeleteMapping(value={"/functions/**"})
    public ResponseEntity<Object> callDeleteFunction(HttpServletRequest request, @RequestBody(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callDeleteFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @GetMapping(value={"/functions/anonymous/**"})
    public ResponseEntity<Object> callGetAnonymousFunction(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callGetAnonymousFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/anonymous/**"})
    public ResponseEntity<Object> callPostAnonymousFunction(HttpServletRequest request, @RequestBody(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callPostAnonymousFunction(functionKey, functionInput);
    }

    @IgnoreLogginAspect
    @Timed
    @PostMapping(value={"/functions/anonymous/**"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Object> callPostFormAnonymousFunction(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> functionInput) {
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        return this.self.callPostFormAnonymousFunction(functionKey, functionInput);
    }

    public FunctionResource(FunctionServiceFacade functionService) {
        this.functionService = functionService;
    }
}

