/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.exceptions.EntityNotFoundException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.lowlevel.Compose;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

public class YamlPatchUtils {
    private static final Logger log = LoggerFactory.getLogger(YamlPatchUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String addObject(String yamlText, Object value, List<YamlPatchPattern> path) {
        Optional<Node> rootNode = YamlPatchUtils.loadYamlNode((String)yamlText);
        if (rootNode.isEmpty()) {
            log.warn("Failed to load YAML from text: {}", yamlText);
            return yamlText;
        }
        List<YamlNode> result = YamlPatchUtils.searchNodes(new YamlNode(rootNode.get(), null), path, 0);
        if (result.isEmpty()) {
            log.warn("No nodes found for path: {}", (Object)YamlPatchUtils.printPath(path));
            return yamlText;
        }
        YamlNode targetNode = result.getFirst();
        List<String> lines = ((String)yamlText).lines().toList();
        int line = targetNode.node.getEndMark().map(Mark::getLine).orElse(lines.size());
        int index = YamlPatchUtils.getIndex((String)yamlText, targetNode);
        yamlText = ((String)yamlText).substring(0, index) + "\n" + ((String)yamlText).substring(index);
        return YamlPatchUtils.insertString(value, targetNode, (String)yamlText, line);
    }

    public static String addSequenceItem(String yamlText, Object value, List<YamlPatchPattern> path) {
        return YamlPatchUtils.addObject(yamlText, List.of(value), path);
    }

    public static String delete(String yamlText, List<YamlPatchPattern> path) {
        Optional<Node> rootNode = YamlPatchUtils.loadYamlNode(yamlText);
        if (rootNode.isEmpty()) {
            log.warn("Failed to load YAML from text: {}", (Object)yamlText);
            return yamlText;
        }
        List<YamlNode> result = YamlPatchUtils.searchNodes(new YamlNode(rootNode.get(), null), path, 0);
        List<Range> toDelete = result.stream().map(YamlPatchUtils::getLinesRange).filter(Objects::nonNull).toList();
        return YamlPatchUtils.removeRangesFromString(yamlText, toDelete);
    }

    public static String updateSequenceItem(String yamlText, Object value, List<YamlPatchPattern> path) {
        return YamlPatchUtils.updateObject(yamlText, List.of(value), path);
    }

    public static String updateObject(String yamlText, Object value, List<YamlPatchPattern> path) {
        Optional<Node> rootNode = YamlPatchUtils.loadYamlNode((String)yamlText);
        if (rootNode.isEmpty()) {
            log.warn("Failed to load YAML from text: {}", yamlText);
            return yamlText;
        }
        List<YamlNode> result = YamlPatchUtils.searchNodes(new YamlNode(rootNode.get(), null), path, 0);
        if (result.isEmpty()) {
            log.warn("No nodes found for path: {}", (Object)YamlPatchUtils.printPath(path));
            throw new EntityNotFoundException("Nodes not found for path: " + YamlPatchUtils.printPath(path));
        }
        YamlNode targetNode = result.getFirst();
        Range toUpdate = YamlPatchUtils.getLinesRange(targetNode);
        int index = YamlPatchUtils.getIndex((String)yamlText, targetNode);
        yamlText = ((String)yamlText).substring(0, index) + "\n" + ((String)yamlText).substring(index);
        String updateText = YamlPatchUtils.removeRangesFromString((String)yamlText, List.of(toUpdate));
        return YamlPatchUtils.insertString(value, targetNode.parent, updateText, toUpdate.startLine);
    }

    private static int getIndex(String yamlText, YamlNode targetNode) {
        return targetNode.node.getEndMark().map(endMark -> {
            int line = endMark.getLine();
            int column = endMark.getColumn();
            List<String> lines = yamlText.lines().toList();
            if (lines.size() > line && line > 0 && lines.get(line - 1).substring(0, column).isBlank()) {
                return endMark.getIndex() - column;
            }
            return endMark.getIndex();
        }).orElse(yamlText.length());
    }

    public static YamlPatchPattern key(String key) {
        return YamlPatchUtils.wrapper(node -> {
            ArrayList<Node> result = new ArrayList<Node>();
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                for (NodeTuple t : mappingNode.getValue()) {
                    Node keyNode = t.getKeyNode();
                    if (!key.equals(YamlPatchUtils.keyToString(keyNode))) continue;
                    result.add(t.getValueNode());
                }
            }
            return result;
        }, "." + key);
    }

    public static YamlPatchPattern array() {
        return YamlPatchUtils.wrapper(node -> {
            ArrayList result = new ArrayList();
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNode = (SequenceNode)node;
                result.addAll(sequenceNode.getValue());
            }
            return result;
        }, "[]");
    }

    public static YamlPatchPattern arrayByField(Map<String, String> fieldValues) {
        return YamlPatchUtils.wrapper(node -> {
            ArrayList<Node> result = new ArrayList<Node>();
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNode = (SequenceNode)node;
                for (Node item : sequenceNode.getValue()) {
                    MappingNode mappingNode;
                    List tuple;
                    Map<String, Object> values;
                    if (!(item instanceof MappingNode) || !YamlPatchUtils.compareAllFields(fieldValues, values = YamlPatchUtils.convertTupleToMap(tuple = (mappingNode = (MappingNode)item).getValue()))) continue;
                    result.add(item);
                }
            }
            return result;
        }, "[" + fieldValues.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).reduce((a, b) -> a + ", " + b).orElse("") + "]");
    }

    private static String insertString(Object value, YamlNode targetNode, String yamlText, int line) {
        List<String> lines = yamlText.lines().toList();
        int startingSpaces = YamlPatchUtils.getStartingSpaces(targetNode);
        String valueYaml = YamlPatchUtils.buildTargetYaml(value, startingSpaces);
        StringBuilder resultYaml = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            if (Math.abs(i - line) > 1 || !StringUtils.isEmpty((CharSequence)lines.get(i))) {
                resultYaml.append(lines.get(i)).append("\n");
            }
            if (i != line) continue;
            resultYaml.append(valueYaml);
        }
        if (lines.size() <= line) {
            resultYaml.append(valueYaml);
        }
        return resultYaml.toString();
    }

    private static String printPath(List<YamlPatchPattern> path) {
        return String.join((CharSequence)"", path.stream().map(Object::toString).toList());
    }

    private static String buildTargetYaml(Object value, int startingSpaces) {
        String valueYaml = objectMapper.writeValueAsString(value);
        Stream<String> lines = valueYaml.lines();
        StringBuilder valueString = new StringBuilder();
        lines.skip(1L).forEach(line -> {
            if (StringUtils.isBlank((CharSequence)line)) {
                valueString.append("\n");
            } else {
                valueString.append(" ".repeat(startingSpaces)).append((String)line).append("\n");
            }
        });
        return valueString.toString();
    }

    private static int getStartingSpaces(YamlNode yamlNode) {
        int defaultSpaces = yamlNode.parent == null ? 2 : yamlNode.parent.node.getStartMark().map(Mark::getColumn).orElse(0) + 2;
        Node node = yamlNode.node;
        Objects.requireNonNull(node);
        Node node2 = node;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MappingNode.class, SequenceNode.class}, (Object)node2, n)) {
            case 0: {
                MappingNode mappingNode = (MappingNode)node2;
                List values = mappingNode.getValue();
                if (values.isEmpty()) {
                    return defaultSpaces;
                }
                return ((NodeTuple)values.getFirst()).getKeyNode().getStartMark().map(Mark::getColumn).orElse(defaultSpaces);
            }
            case 1: {
                SequenceNode sequenceNode = (SequenceNode)node2;
                List values = sequenceNode.getValue();
                if (values.isEmpty()) {
                    return defaultSpaces;
                }
                Node firstItem = (Node)values.getFirst();
                return firstItem.getStartMark().map(Mark::getColumn).map(it -> it - 2).orElse(defaultSpaces);
            }
        }
        return defaultSpaces;
    }

    private static Optional<Node> loadYamlNode(String yamlText) {
        LoadSettings settings = LoadSettings.builder().build();
        Compose compose = new Compose(settings);
        return compose.composeString(yamlText);
    }

    private static String removeRangesFromString(String yamlText, List<Range> toDelete) {
        StringBuilder sb = new StringBuilder();
        List<String> lines = yamlText.lines().toList();
        for (int i = 0; i < lines.size(); ++i) {
            int line = i;
            boolean isDeleted = toDelete.stream().anyMatch(range -> range.isInside(line));
            if (isDeleted) continue;
            sb.append(lines.get(i)).append("\n");
        }
        return sb.toString();
    }

    public static List<YamlNode> searchNodes(YamlNode yamlNode, List<YamlPatchPattern> path, int pathIndex) {
        if (pathIndex >= path.size()) {
            return List.of(yamlNode);
        }
        List<Node> acceptedChildren = path.get(pathIndex).apply(yamlNode.node);
        return acceptedChildren.stream().flatMap(it -> YamlPatchUtils.searchNodes(new YamlNode((Node)it, yamlNode), path, pathIndex + 1).stream()).filter(Objects::nonNull).toList();
    }

    private static Range getLinesRange(YamlNode yamlNode) {
        Optional startMarkOpt = yamlNode.node.getStartMark();
        Optional endMarkOpt = yamlNode.node.getEndMark();
        if (startMarkOpt.isEmpty() || endMarkOpt.isEmpty()) {
            return null;
        }
        int index = ((Mark)endMarkOpt.get()).getIndex();
        return new Range(((Mark)startMarkOpt.get()).getLine(), ((Mark)endMarkOpt.get()).getLine(), index);
    }

    private static String keyToString(Node keyNode) {
        if (keyNode instanceof ScalarNode) {
            ScalarNode s = (ScalarNode)keyNode;
            return s.getValue();
        }
        return "[complex-key]";
    }

    private static Map<String, Object> convertTupleToMap(List<NodeTuple> tuple) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (NodeTuple t : tuple) {
            Node keyNode = t.getKeyNode();
            String key = YamlPatchUtils.keyToString(keyNode);
            Node node = t.getValueNode();
            if (!(node instanceof ScalarNode)) continue;
            ScalarNode scalarNode = (ScalarNode)node;
            values.put(key, scalarNode.getValue());
        }
        return values;
    }

    private static boolean compareAllFields(Map<String, String> fieldValues, Map<String, Object> values) {
        return fieldValues.entrySet().stream().allMatch(entry -> Objects.equals(entry.getValue(), values.get(entry.getKey())));
    }

    public static YamlPatchPattern wrapper(final Function<Node, List<Node>> function, final String presentation) {
        return new YamlPatchPattern(){

            @Override
            List<Node> apply(Node node) {
                return (List)function.apply(node);
            }

            public String toString() {
                return presentation;
            }
        };
    }

    public record YamlNode(Node node, YamlNode parent) {
    }

    public record Range(int startLine, int endLine, int index) {
        public boolean isInside(int line) {
            return line >= this.startLine && line < this.endLine;
        }
    }

    public static abstract class YamlPatchPattern {
        abstract List<Node> apply(Node var1);
    }
}

