/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config;

import com.icthh.xm.commons.config.FunctionApiSpecConfiguration;
import com.icthh.xm.commons.config.client.repository.CommonConfigRepository;
import com.icthh.xm.commons.config.client.service.CommonConfigService;
import com.icthh.xm.commons.domain.DefaultFunctionResult;
import com.icthh.xm.commons.domain.FunctionSpecWithFileName;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.service.FunctionExecutorService;
import com.icthh.xm.commons.service.FunctionManageService;
import com.icthh.xm.commons.service.FunctionResultProcessor;
import com.icthh.xm.commons.service.FunctionService;
import com.icthh.xm.commons.service.FunctionServiceFacade;
import com.icthh.xm.commons.service.FunctionTxControl;
import com.icthh.xm.commons.service.impl.AbstractFunctionServiceFacade;
import com.icthh.xm.commons.service.impl.FunctionManageServiceImpl;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FunctionApiConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FunctionApiConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={FunctionResultProcessor.class})
    public FunctionResultProcessor<FunctionSpec> functionResultProcessor() {
        return (functionKey, executorResult, functionSpec) -> {
            log.debug("Function result wrapping is not implemented for function: {}", (Object)functionKey);
            return new DefaultFunctionResult(executorResult, functionSpec.getWrapResult());
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={FunctionServiceFacade.class})
    public FunctionServiceFacade functionServiceFacade(FunctionService<FunctionSpec> functionService, FunctionTxControl functionTxControl, FunctionExecutorService functionExecutorService, FunctionResultProcessor<FunctionSpec> functionResultProcessor) {
        return new AbstractFunctionServiceFacade<FunctionSpec>(this, functionService, functionTxControl, functionExecutorService, functionResultProcessor){};
    }

    @Bean
    @ConditionalOnMissingBean(value={FunctionManageService.class})
    public FunctionManageService<FunctionSpec, FunctionSpecWithFileName<FunctionSpec>> functionManageService(FunctionApiSpecConfiguration functionApiSpecConfiguration, TenantContextHolder tenantContextHolder, CommonConfigRepository commonConfigRepository, CommonConfigService commonConfigService) {
        return new FunctionManageServiceImpl(functionApiSpecConfiguration, tenantContextHolder, commonConfigRepository, commonConfigService);
    }
}

