/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.rest;

import com.codahale.metrics.annotation.Timed;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.service.FunctionSpecService;
import com.icthh.xm.commons.web.rest.response.DataSchemaResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/functions"})
public class FunctionSpecResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionSpecResource.class);
    private final FunctionSpecService functionSpecService;

    @GetMapping(value={"/dataschemas"}, produces={"application/json"})
    @Timed
    @PostAuthorize(value="hasPermission({'returnObject': returnObject.body}, 'FUNCTION_SPEC.DATA_SCHEMA.GET')")
    @PrivilegeDescription(value="Privilege to get the function specification data schema")
    public ResponseEntity<List<DataSchemaResponse>> getDataSpecSchemas() {
        return ResponseEntity.ok().body(this.functionSpecService.getDataSpecSchemas());
    }

    public FunctionSpecResource(FunctionSpecService functionSpecService) {
        this.functionSpecService = functionSpecService;
    }
}

