/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config;

import com.icthh.xm.commons.domain.spec.FunctionApiSpecs;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.processor.impl.DefinitionSpecProcessor;
import com.icthh.xm.commons.processor.impl.FormSpecProcessor;
import com.icthh.xm.commons.service.DefaultSpecProcessingService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FunctionApiSpecsProcessor
extends DefaultSpecProcessingService<FunctionApiSpecs> {
    private static final Logger log = LoggerFactory.getLogger(FunctionApiSpecsProcessor.class);
    private final DefinitionSpecProcessor definitionSpecProcessor;
    private final FormSpecProcessor formSpecProcessor;

    public FunctionApiSpecsProcessor(DefinitionSpecProcessor definitionSpecProcessor, FormSpecProcessor formSpecProcessor) {
        super(definitionSpecProcessor, formSpecProcessor);
        this.definitionSpecProcessor = definitionSpecProcessor;
        this.formSpecProcessor = formSpecProcessor;
    }

    public FunctionApiSpecs processSpecification(String tenant, String baseSpecKey, FunctionApiSpecs specification) {
        Optional.ofNullable(specification.getItems()).orElseGet(List::of).stream().filter(Objects::nonNull).forEach(f -> {
            this.processValidateInputParameter(specification.isValidateFunctionInput(), (FunctionSpec)f);
            this.definitionSpecProcessor.processDataSpec(tenant, baseSpecKey, f::setInputDataSpec, f::getInputDataSpec);
            this.definitionSpecProcessor.processDataSpec(tenant, baseSpecKey, f::setOutputDataSpec, f::getOutputDataSpec);
            this.formSpecProcessor.processDataSpec(tenant, baseSpecKey, f::setInputFormSpec, f::getInputFormSpec);
            this.formSpecProcessor.processDataSpec(tenant, baseSpecKey, f::setOutputFormSpec, f::getOutputFormSpec);
        });
        this.definitionSpecProcessor.processDefinitionsItSelf(tenant, baseSpecKey);
        return specification;
    }

    private void processValidateInputParameter(boolean isValidateFunctionInput, FunctionSpec functionSpec) {
        if (functionSpec.getValidateFunctionInput() == null) {
            functionSpec.setValidateFunctionInput(isValidateFunctionInput);
        }
    }
}

