/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import com.icthh.xm.commons.domain.FunctionResult;
import com.icthh.xm.commons.utils.HeaderUtils;
import java.net.URI;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public final class ResponseEntityUtils {
    public static ResponseEntity<Object> processCreatedResponse(String appName, FunctionResult result) {
        return Optional.ofNullable(result.getId()).map(id -> URI.create("/api/function-contexts/" + id)).map(uri -> ResponseEntityUtils.buildCreatedResponseWithHeaders(appName, uri, result)).orElse(ResponseEntityUtils.buildCreatedResponse(result));
    }

    private static ResponseEntity<Object> buildCreatedResponseWithHeaders(String appName, URI uri, FunctionResult result) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(HeaderUtils.createEntityCreationAlert(appName, "functionContext", String.valueOf(result.getId())))).body(result.functionResult());
    }

    private static ResponseEntity<Object> buildCreatedResponse(FunctionResult result) {
        return ResponseEntity.status((int)HttpStatus.CREATED.value()).body(result.functionResult());
    }

    private ResponseEntityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

