/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.icthh.xm.commons.domain.spec.IFunctionSpec;
import com.icthh.xm.commons.swagger.model.BodyContent;
import com.icthh.xm.commons.swagger.model.SwaggerContent;
import com.icthh.xm.commons.swagger.model.SwaggerResponse;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwaggerGeneratorUtils {
    private static final Logger log = LoggerFactory.getLogger(SwaggerGeneratorUtils.class);
    public static final Set<String> SUPPORTED_ANONYMOUS_HTTP_METHODS = Set.of("GET", "POST", "POST_URLENCODED");
    public static final Set<String> SUPPORTED_HTTP_METHODS = Set.of("GET", "POST", "PUT", "DELETE", "PATCH", "POST_URLENCODED");

    @NotNull
    public static List<String> getPathVariables(String swaggerFunctionPath) {
        ArrayList<String> variablesInPath = new ArrayList<String>();
        new StringSubstitutor(key -> {
            variablesInPath.add(key);
            return key;
        }, "{", "}", '\\').replace(swaggerFunctionPath);
        return variablesInPath;
    }

    public static boolean skipUnsupportedFields(Map.Entry<String, JsonNode> field) {
        if (field.getKey().equals("$ref")) {
            log.warn("$ref in query parameters is not supported");
            return true;
        }
        if (field.getValue().has("type") && field.getValue().get("type").asText().equals("object")) {
            log.warn("Object in query parameters is not supported");
            return true;
        }
        if (field.getValue().has("type") && field.getValue().get("type").asText().equals("array")) {
            JsonNode items = field.getValue().get("items");
            if (items.has("type") && items.get("type").asText().equals("object")) {
                log.warn("Array of objects in query parameters is not supported");
                return true;
            }
            if (items.has("$ref")) {
                log.warn("Array of $ref in query parameters is not supported");
                return true;
            }
        }
        return false;
    }

    public static Map<String, SwaggerResponse> getResponses() {
        HashMap<String, SwaggerResponse> responses = new HashMap<String, SwaggerResponse>();
        responses.put("400", SwaggerGeneratorUtils.getResponse("Bad request. Request invalid by business rules"));
        responses.put("401", SwaggerGeneratorUtils.getResponse("Invalid access token"));
        responses.put("403", SwaggerGeneratorUtils.getResponse("Forbidden"));
        responses.put("404", SwaggerGeneratorUtils.getResponse("Not found"));
        responses.put("500", SwaggerGeneratorUtils.getResponse("Internal server error"));
        return responses;
    }

    private static SwaggerResponse getResponse(String description) {
        return new SwaggerResponse(new BodyContent(new SwaggerContent(Map.of("$ref", "#/components/schemas/RequestError"))), description);
    }

    public static Map<String, Object> getRequestErrorDefinition() {
        return Map.of("type", "object", "properties", Map.of("error", Map.of("type", "string"), "error_description", Map.of("type", "string")));
    }

    public static String makeAsPath(String path, String key) {
        Object result = StringUtils.isNotBlank((CharSequence)path) ? path : key;
        result = StringUtils.stripStart((String)result, (String)"/");
        result = StringUtils.stripEnd((String)result, (String)"/");
        result = "/" + (String)result;
        return result;
    }

    public static List<HttpMethodFilter> getSupportedHttpMethodFilters() {
        return new ArrayList<HttpMethodFilter>(List.of(new HttpMethodFilter(fs -> Boolean.TRUE.equals(fs.getAnonymous()), methods -> SwaggerGeneratorUtils.filterHttpMethods(methods, SUPPORTED_ANONYMOUS_HTTP_METHODS)), new HttpMethodFilter(fs -> true, methods -> SwaggerGeneratorUtils.filterHttpMethods(methods, SUPPORTED_HTTP_METHODS))));
    }

    public static List<String> filterHttpMethods(List<String> httpMethods, Set<String> supportedMethods) {
        return httpMethods.stream().filter(supportedMethods::contains).collect(Collectors.toList());
    }

    private SwaggerGeneratorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class HttpMethodFilter {
        private final Predicate<IFunctionSpec> condition;
        private final Function<List<String>, List<String>> action;

        public boolean supported(IFunctionSpec functionSpec) {
            return this.condition.test(functionSpec);
        }

        public List<String> filter(List<String> httpMethods) {
            return this.action.apply(httpMethods);
        }

        public HttpMethodFilter(Predicate<IFunctionSpec> condition, Function<List<String>, List<String>> action) {
            this.condition = condition;
            this.action = action;
        }
    }
}

