/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.swagger.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.icthh.xm.commons.swagger.model.BodyContent;
import com.icthh.xm.commons.swagger.model.RequestBody;
import com.icthh.xm.commons.swagger.model.SwaggerContent;
import com.icthh.xm.commons.swagger.model.SwaggerParameter;
import com.icthh.xm.commons.swagger.model.SwaggerResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;
import org.springframework.http.HttpMethod;

public class ApiMethod {
    private static final Set<String> METHODS_WITH_BODY = Set.of(HttpMethod.POST.name(), HttpMethod.PUT.name(), HttpMethod.PATCH.name(), "POST_URLENCODED");
    private String summary;
    private String description;
    private String operationId;
    private List<String> tags = new ArrayList<String>();
    private List<SwaggerParameter> parameters = new ArrayList<SwaggerParameter>();
    private Object requestBody;
    private Map<String, SwaggerResponse> responses = new LinkedHashMap<String, SwaggerResponse>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Object> security;

    public void setOperationId(String operationId, boolean hasMultipleHttpMethods, String httpMethod) {
        if (hasMultipleHttpMethods) {
            operationId = (String)operationId + httpMethod;
        }
        operationId = String.join((CharSequence)"-", StringUtils.splitByCharacterTypeCamelCase((String)operationId));
        this.operationId = operationId = CaseUtils.toCamelCase((String)operationId, (boolean)false, (char[])new char[]{'_', '-', '/', ' '});
    }

    public void generateDefaultResponses() {
        this.responses.put("400", new SwaggerResponse("#/components/responses/400"));
        this.responses.put("401", new SwaggerResponse("#/components/responses/401"));
        this.responses.put("403", new SwaggerResponse("#/components/responses/403"));
        this.responses.put("404", new SwaggerResponse("#/components/responses/404"));
        this.responses.put("500", new SwaggerResponse("#/components/responses/500"));
    }

    public void setRequestBody(List<String> httpMethods, Map<String, Object> schema, String httpMethod) {
        if (!METHODS_WITH_BODY.contains(httpMethod)) {
            return;
        }
        if (httpMethod.equals(HttpMethod.POST.name()) && httpMethods.contains("POST_URLENCODED")) {
            this.requestBody = new RequestBody((Boolean)true, Map.of("application/x-www-form-urlencoded", new SwaggerContent(schema), "application/json", new SwaggerContent(schema)));
        } else if (httpMethod.equals("POST_URLENCODED") && !httpMethods.contains(HttpMethod.POST.name())) {
            this.requestBody = new RequestBody((Boolean)true, Map.of("application/x-www-form-urlencoded", new SwaggerContent(schema)));
        } else if (!httpMethod.equals("POST_URLENCODED")) {
            this.requestBody = new RequestBody((Boolean)true, new BodyContent(new SwaggerContent(schema)));
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<SwaggerParameter> getParameters() {
        return this.parameters;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Map<String, SwaggerResponse> getResponses() {
        return this.responses;
    }

    public List<Object> getSecurity() {
        return this.security;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setParameters(List<SwaggerParameter> parameters) {
        this.parameters = parameters;
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public void setResponses(Map<String, SwaggerResponse> responses) {
        this.responses = responses;
    }

    public void setSecurity(List<Object> security) {
        this.security = security;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiMethod)) {
            return false;
        }
        ApiMethod other = (ApiMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$operationId = this.getOperationId();
        String other$operationId = other.getOperationId();
        if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<SwaggerParameter> this$parameters = this.getParameters();
        List<SwaggerParameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Object this$requestBody = this.getRequestBody();
        Object other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        Map<String, SwaggerResponse> this$responses = this.getResponses();
        Map<String, SwaggerResponse> other$responses = other.getResponses();
        if (this$responses == null ? other$responses != null : !((Object)this$responses).equals(other$responses)) {
            return false;
        }
        List<Object> this$security = this.getSecurity();
        List<Object> other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $operationId = this.getOperationId();
        result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<SwaggerParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Object $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        Map<String, SwaggerResponse> $responses = this.getResponses();
        result = result * 59 + ($responses == null ? 43 : ((Object)$responses).hashCode());
        List<Object> $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        return result;
    }

    public String toString() {
        return "ApiMethod(summary=" + this.getSummary() + ", description=" + this.getDescription() + ", operationId=" + this.getOperationId() + ", tags=" + String.valueOf(this.getTags()) + ", parameters=" + String.valueOf(this.getParameters()) + ", requestBody=" + String.valueOf(this.getRequestBody()) + ", responses=" + String.valueOf(this.getResponses()) + ", security=" + String.valueOf(this.getSecurity()) + ")";
    }
}

