/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.swagger.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.config.swagger.DynamicSwaggerConfiguration;
import com.icthh.xm.commons.swagger.JsonSchemaToSwaggerSchemaConverter;
import com.icthh.xm.commons.swagger.SwaggerGenerator;
import com.icthh.xm.commons.swagger.model.ApiMethod;
import com.icthh.xm.commons.swagger.model.BodyContent;
import com.icthh.xm.commons.swagger.model.ServerObject;
import com.icthh.xm.commons.swagger.model.SwaggerContent;
import com.icthh.xm.commons.swagger.model.SwaggerFunction;
import com.icthh.xm.commons.swagger.model.SwaggerModel;
import com.icthh.xm.commons.swagger.model.SwaggerParameter;
import com.icthh.xm.commons.swagger.model.SwaggerResponse;
import com.icthh.xm.commons.utils.SwaggerGeneratorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public abstract class AbstractSwaggerGenerator
implements SwaggerGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractSwaggerGenerator.class);
    private static final Set<String> METHODS_WITH_PARAMS = Set.of(HttpMethod.GET.name(), HttpMethod.DELETE.name());
    private final SwaggerModel swaggerBody = new SwaggerModel();
    private final JsonSchemaToSwaggerSchemaConverter jsonSchemaConverter;
    private final Map<String, Object> definitions = new LinkedHashMap<String, Object>();
    private final Map<String, Object> originalDefinitions = new LinkedHashMap<String, Object>();
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private final DynamicSwaggerConfiguration configuration;

    public AbstractSwaggerGenerator(String baseUrl, DynamicSwaggerConfiguration configuration, JsonSchemaToSwaggerSchemaConverter jsonSchemaConverter) {
        this.configuration = configuration;
        this.jsonSchemaConverter = jsonSchemaConverter;
        this.swaggerBody.setServers(List.of(new ServerObject(baseUrl)));
        Optional.ofNullable(configuration).map(DynamicSwaggerConfiguration::getInfo).ifPresent(this.swaggerBody::setInfo);
        Optional.ofNullable(configuration).map(DynamicSwaggerConfiguration::getTags).ifPresent(this.swaggerBody::setTags);
        Optional.ofNullable(configuration).map(DynamicSwaggerConfiguration::getServers).ifPresent(this.swaggerBody::setServers);
        this.swaggerBody.getComponents().setSchemas(this.definitions);
        this.swaggerBody.getComponents().getResponses().putAll(SwaggerGeneratorUtils.getResponses());
        this.definitions.put("RequestError", SwaggerGeneratorUtils.getRequestErrorDefinition());
    }

    public abstract void enrichApiMethod(ApiMethod var1, Map<String, SwaggerParameter> var2, SwaggerFunction var3, String var4);

    public abstract ObjectNode generateFunctionContext();

    @Override
    public SwaggerModel getSwaggerBody() {
        return this.swaggerBody;
    }

    @Override
    public void generateFunction(String pathPrefix, Map<String, SwaggerParameter> pathPrefixParams, SwaggerFunction swaggerFunction) {
        Map<String, Map<String, ApiMethod>> paths = this.swaggerBody.getPaths();
        HashMap methods = new HashMap();
        swaggerFunction.getHttpMethods().stream().filter(m -> !m.equalsIgnoreCase("POST_URLENCODED") || !swaggerFunction.getHttpMethods().contains(HttpMethod.POST.name())).forEach(httpMethod -> {
            ApiMethod apiMethod = this.generateApiMethod(pathPrefixParams, swaggerFunction, (String)httpMethod);
            httpMethod = httpMethod.equalsIgnoreCase("POST_URLENCODED") ? HttpMethod.POST.name() : httpMethod;
            methods.put(httpMethod.toLowerCase(), apiMethod);
        });
        paths.computeIfAbsent(pathPrefix + swaggerFunction.getPath(), k -> new HashMap()).putAll(methods);
    }

    private ApiMethod generateApiMethod(Map<String, SwaggerParameter> pathPrefixParams, SwaggerFunction swaggerFunction, String httpMethod) {
        ApiMethod operation = new ApiMethod();
        operation.setOperationId(swaggerFunction.getOperationId(), swaggerFunction.hasMultipleHttpMethods(), httpMethod);
        this.buildParameters(pathPrefixParams, swaggerFunction, operation, httpMethod);
        operation.setSummary(swaggerFunction.getName());
        operation.setDescription(swaggerFunction.getDescription());
        operation.setTags(swaggerFunction.getTags());
        this.buildResponse(swaggerFunction, operation, httpMethod);
        if (Boolean.TRUE.equals(swaggerFunction.getAnonymous())) {
            operation.setSecurity(List.of());
        }
        this.enrichApiMethod(operation, pathPrefixParams, swaggerFunction, httpMethod);
        return operation;
    }

    private void buildResponse(SwaggerFunction swaggerFunction, ApiMethod operation, String httpMethod) {
        operation.setResponses(new LinkedHashMap<String, SwaggerResponse>());
        operation.generateDefaultResponses();
        if (HttpMethod.POST.name().equals(httpMethod) || "POST_URLENCODED".equals(httpMethod)) {
            this.addSuccess(swaggerFunction, operation, "201");
        } else {
            this.addSuccess(swaggerFunction, operation, "200");
        }
    }

    private void addSuccess(SwaggerFunction swaggerFunction, ApiMethod operation, String code) {
        String successfulMessage = "Successful operation";
        JsonNode jsonNode = this.jsonSchemaConverter.transformToJsonNode(operation.getOperationId(), swaggerFunction.getOutputJsonSchema(), this.definitions, this.originalDefinitions);
        if (Boolean.TRUE.equals(swaggerFunction.getWrapResult())) {
            ObjectNode functionContext = this.generateFunctionContext();
            ObjectNode properties = (ObjectNode)functionContext.get("properties");
            if (StringUtils.isNotBlank((CharSequence)swaggerFunction.getOutputJsonSchema())) {
                properties.set("data", jsonNode);
            } else {
                ObjectNode objectNode = this.objectMapper.createObjectNode();
                objectNode.put("type", "object");
                objectNode.put("additionalProperties", true);
                properties.set("data", (JsonNode)objectNode);
            }
            jsonNode = functionContext;
        }
        Map<String, Object> schema = this.convertToMap(jsonNode);
        operation.getResponses().put(code, new SwaggerResponse(new BodyContent(new SwaggerContent(schema)), successfulMessage));
    }

    private void buildParameters(Map<String, SwaggerParameter> pathPrefixParams, SwaggerFunction swaggerFunction, ApiMethod operation, String httpMethod) {
        JsonNode jsonNode = this.jsonSchemaConverter.transformToJsonNode(operation.getOperationId(), swaggerFunction.getInputJsonSchema(), this.definitions, this.originalDefinitions);
        this.jsonSchemaConverter.inlineRootRef(jsonNode, this.definitions);
        LinkedHashMap<String, SwaggerParameter> parameters = new LinkedHashMap<String, SwaggerParameter>(pathPrefixParams);
        this.addPathParameters(swaggerFunction.getPath(), jsonNode, parameters);
        this.addQueryParameters(jsonNode, parameters, httpMethod);
        if (StringUtils.isNotBlank((CharSequence)swaggerFunction.getInputJsonSchema())) {
            Map<String, Object> schema = this.convertToMap(jsonNode);
            operation.setRequestBody(swaggerFunction.getHttpMethods(), schema, httpMethod);
        }
        operation.setParameters(new ArrayList<SwaggerParameter>(parameters.values()));
    }

    private Map<String, Object> convertToMap(JsonNode jsonNode) {
        return (Map)this.objectMapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(this){});
    }

    private void addQueryParameters(JsonNode jsonNode, Map<String, SwaggerParameter> parameters, String httpMethod) {
        if (METHODS_WITH_PARAMS.contains(httpMethod) && jsonNode.isObject() && jsonNode.has("properties")) {
            ObjectNode object = (ObjectNode)jsonNode.get("properties");
            Iterator fields = object.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (SwaggerGeneratorUtils.skipUnsupportedFields(field)) continue;
                Map<String, Object> schema = this.convertToMap((JsonNode)field.getValue());
                parameters.put((String)field.getKey(), new SwaggerParameter("query", (String)field.getKey(), true, schema));
                fields.remove();
            }
        }
    }

    private void addPathParameters(String swaggerFunctionPath, JsonNode jsonNode, Map<String, SwaggerParameter> parameters) {
        List<String> variablesInPath = SwaggerGeneratorUtils.getPathVariables(swaggerFunctionPath);
        variablesInPath.forEach(variable -> {
            if (jsonNode.has("properties") && jsonNode.get("properties").has(variable)) {
                ObjectNode object = (ObjectNode)jsonNode.get("properties");
                JsonNode variableSchema = object.remove(variable);
                Map<String, Object> schema = this.convertToMap(variableSchema);
                parameters.put((String)variable, new SwaggerParameter((String)variable, true, schema));
            } else {
                parameters.put((String)variable, new SwaggerParameter((String)variable, true, Map.of("type", "string")));
            }
        });
    }
}

