/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.icthh.xm.commons.domain.FunctionResult;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.service.FunctionServiceFacade;
import com.icthh.xm.commons.utils.HttpRequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class FunctionUploadResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionUploadResource.class);
    public static final String UPLOAD = "/upload";
    public static final String HTTP_SERVLET_REQUEST_KEY = "httpServletRequest";
    public static final String FILES_KEY = "files";
    private final FunctionServiceFacade functionService;

    @Timed
    @PostMapping(value={"/functions/**"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.UPLOAD.CALL')")
    @PrivilegeDescription(value="Privilege to call upload function")
    public ResponseEntity<Object> callUploadFunction(HttpServletRequest request, @RequestParam(value="file", required=false) List<MultipartFile> files, HttpServletRequest httpServletRequest) {
        if (!request.getRequestURI().endsWith(UPLOAD)) {
            return ResponseEntity.badRequest().body((Object)"Invalid upload url");
        }
        ImmutableMap functionInput = ImmutableMap.of((Object)HTTP_SERVLET_REQUEST_KEY, (Object)httpServletRequest, (Object)FILES_KEY, files);
        String functionKey = HttpRequestUtils.getFunctionKey(request);
        functionKey = functionKey.substring(0, functionKey.length() - UPLOAD.length());
        FunctionResult result = this.functionService.execute(functionKey, (Map<String, Object>)functionInput, HttpMethod.POST.name());
        return ResponseEntity.ok().body(result.functionResult());
    }

    public FunctionUploadResource(FunctionServiceFacade functionService) {
        this.functionService = functionService;
    }
}

