/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.exporter;

import com.icthh.xm.commons.domain.BaseRow;
import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.service.FunctionExecutorService;
import com.icthh.xm.commons.service.exporter.ExportService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpMethod;

public abstract class AbstractExportServiceImpl<T extends BaseRow>
implements ExportService {
    private static final Logger log = LoggerFactory.getLogger(AbstractExportServiceImpl.class);
    @Value(value="${application.function.export.defaultPageSize:1000}")
    protected Integer defaultPageSize;
    private final FunctionExecutorService functionExecutorService;

    public AbstractExportServiceImpl(FunctionExecutorService functionExecutorService) {
        this.functionExecutorService = functionExecutorService;
    }

    protected Page<T> getNextPage(Integer page, String functionKey, Map<String, Object> functionInput) {
        functionInput.put("page", page);
        functionInput.put("size", this.defaultPageSize);
        Object result = this.functionExecutorService.execute(functionKey, functionInput, HttpMethod.GET.name());
        if (result == null) {
            log.error("Empty export data for file");
            throw new BusinessException("Empty export data for file; functionKey: " + functionKey + "; page: " + page);
        }
        if (result instanceof List) {
            List resultList = (List)result;
            return new PageImpl(resultList, Pageable.unpaged(), (long)resultList.size());
        }
        if (result instanceof Page) {
            return (Page)result;
        }
        log.error("Unexpected function result type: {}", result.getClass());
        throw new BusinessException("Unexpected function result: {}. List or Page are expected.", result.getClass().getName());
    }
}

