/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service;

import com.icthh.xm.commons.domain.BaseSpecification;
import com.icthh.xm.commons.domain.DefinitionSpec;
import com.icthh.xm.commons.domain.FormSpec;
import com.icthh.xm.commons.domain.HasInputDataForm;
import com.icthh.xm.commons.domain.HasInputDataSpec;
import com.icthh.xm.commons.domain.HasOutputDataForm;
import com.icthh.xm.commons.domain.HasOutputDataSpec;
import com.icthh.xm.commons.domain.SpecificationItem;
import com.icthh.xm.commons.processor.impl.DefinitionSpecProcessor;
import com.icthh.xm.commons.processor.impl.FormSpecProcessor;
import com.icthh.xm.commons.service.AbstractSpecProcessingService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class DefaultSpecProcessingService<S extends BaseSpecification>
extends AbstractSpecProcessingService<S> {
    private final DefinitionSpecProcessor definitionSpecProcessor;
    private final FormSpecProcessor formSpecProcessor;

    public DefaultSpecProcessingService(DefinitionSpecProcessor definitionSpecProcessor, FormSpecProcessor formSpecProcessor) {
        super(definitionSpecProcessor);
        this.definitionSpecProcessor = definitionSpecProcessor;
        this.formSpecProcessor = formSpecProcessor;
    }

    @Override
    public <I extends SpecificationItem> void processDataSpecification(String tenant, String baseSpecKey, I spec) {
        Object s;
        if (spec instanceof HasInputDataSpec) {
            s = (HasInputDataSpec)((Object)spec);
            this.definitionSpecProcessor.processDataSpec(tenant, baseSpecKey, ((HasInputDataSpec)s)::setInputDataSpec, ((HasInputDataSpec)s)::getInputDataSpec);
        }
        if (spec instanceof HasOutputDataSpec) {
            s = (HasOutputDataSpec)((Object)spec);
            this.definitionSpecProcessor.processDataSpec(tenant, baseSpecKey, ((HasOutputDataSpec)s)::setOutputDataSpec, ((HasOutputDataSpec)s)::getOutputDataSpec);
        }
        if (spec instanceof HasInputDataForm) {
            s = (HasInputDataForm)((Object)spec);
            this.formSpecProcessor.processDataSpec(tenant, baseSpecKey, ((HasInputDataForm)s)::setInputFormSpec, ((HasInputDataForm)s)::getInputFormSpec);
        }
        if (spec instanceof HasOutputDataForm) {
            s = (HasOutputDataForm)((Object)spec);
            this.formSpecProcessor.processDataSpec(tenant, baseSpecKey, ((HasOutputDataForm)s)::setOutputFormSpec, ((HasOutputDataForm)s)::getOutputFormSpec);
        }
    }

    @Override
    public void fullUpdateByTenantState(String tenant, String baseSpecKey, Collection<S> specs) {
        List<DefinitionSpec> allSpecDefinitions = specs.stream().filter(spec -> Objects.nonNull(spec) && Objects.nonNull(spec.getDefinitions())).flatMap(spec -> spec.getDefinitions().stream()).toList();
        List<FormSpec> allSpecForms = specs.stream().filter(spec -> Objects.nonNull(spec) && Objects.nonNull(spec.getForms())).flatMap(spec -> spec.getForms().stream()).toList();
        this.definitionSpecProcessor.fullUpdateStateByTenant(tenant, baseSpecKey, (Collection<DefinitionSpec>)allSpecDefinitions);
        this.formSpecProcessor.fullUpdateStateByTenant(tenant, baseSpecKey, (Collection<FormSpec>)allSpecForms);
    }
}

