/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.processor.impl;

import com.icthh.xm.commons.domain.DefinitionSpec;
import com.icthh.xm.commons.listener.JsonListenerService;
import com.icthh.xm.commons.processor.DataSpecProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="definitionSpecProcessor")
public class DefinitionSpecProcessor
extends DataSpecProcessor<DefinitionSpec> {
    private static final Logger log = LoggerFactory.getLogger(DefinitionSpecProcessor.class);
    private final Map<String, Map<String, Map<String, DefinitionSpec>>> definitionsByTenant = new ConcurrentHashMap<String, Map<String, Map<String, DefinitionSpec>>>();
    private final Map<String, Map<String, Map<String, DefinitionSpec>>> processedDefinitionsByTenant = new ConcurrentHashMap<String, Map<String, Map<String, DefinitionSpec>>>();

    public DefinitionSpecProcessor(JsonListenerService jsonListenerService) {
        super(jsonListenerService);
    }

    @Override
    public String getSectionName() {
        return "xmDefinition";
    }

    @Override
    public String getReferencePattern() {
        return "#/" + this.getSectionName() + "/**/*";
    }

    @Override
    public String getKeyTemplate() {
        return "#/" + this.getSectionName() + "/{key}/**";
    }

    @Override
    public void fullUpdateStateByTenant(String tenant, String baseSpecKey, Collection<DefinitionSpec> definitionSpecs) {
        Map<String, DefinitionSpec> allDefinitions = this.toKeyMapOverrideDuplicates(definitionSpecs);
        if (!allDefinitions.isEmpty()) {
            log.info("added {} definition specs to tenant: {}", (Object)allDefinitions.size(), (Object)tenant);
            this.definitionsByTenant.computeIfAbsent(tenant, s -> new HashMap()).put(baseSpecKey, allDefinitions);
        }
    }

    @Override
    public void processDataSpecReferences(String tenant, String baseSpecKey, String spec, Map<String, Map<String, Object>> tenantDataSpecs) {
        this.findDataSpecReferencesByPattern(spec, this.getReferencePattern()).forEach(ref -> this.processDefinition(tenant, baseSpecKey, tenantDataSpecs, (String)ref, this.definitionsByTenant, definitionSpec -> this.getDefinitionSpecificationByFile(tenant, (DefinitionSpec)definitionSpec)));
    }

    public Collection<DefinitionSpec> getProcessedSpecsCopy(String tenant, String baseSpecKey) {
        return List.copyOf(this.processedDefinitionsByTenant.getOrDefault(tenant, Map.of()).getOrDefault(baseSpecKey, Map.of()).values());
    }

    public String getDefinitionSpecificationByFile(String tenant, DefinitionSpec definitionSpec) {
        return Optional.ofNullable(definitionSpec.getValue()).orElseGet(() -> this.jsonListenerService.getSpecificationByTenantRelativePath(tenant, definitionSpec.getRef()));
    }

    public void processDefinitionsItSelf(String tenant, String baseSpecKey) {
        LinkedHashMap processed = this.definitionsByTenant.getOrDefault(tenant, Map.of()).getOrDefault(baseSpecKey, Map.of()).entrySet().stream().map(e -> Map.entry((String)e.getKey(), this.getProcessedInputDataSpec(tenant, baseSpecKey, (DefinitionSpec)e.getValue()))).filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (DefinitionSpec)((Optional)entry.getValue()).get(), (e1, e2) -> e1, LinkedHashMap::new));
        Map byTenant = this.processedDefinitionsByTenant.computeIfAbsent(tenant, s -> new HashMap());
        byTenant.put(baseSpecKey, Map.copyOf(processed));
        this.processedDefinitionsByTenant.put(tenant, byTenant);
    }

    private Optional<DefinitionSpec> getProcessedInputDataSpec(String tenant, String baseSpecKey, DefinitionSpec specToProcess) {
        return Optional.ofNullable(this.getDefinitionSpecificationByFile(tenant, specToProcess)).filter(StringUtils::isNotBlank).map(file -> this.processInnerDataSpec(tenant, baseSpecKey, specToProcess.getKey(), (String)file));
    }

    private DefinitionSpec processInnerDataSpec(String tenant, String baseSpecKey, String specKey, String definitionSpecFile) {
        MutableObject definition = new MutableObject((Object)definitionSpecFile);
        this.processDataSpec(tenant, baseSpecKey, arg_0 -> ((Mutable)definition).setValue(arg_0), () -> ((Mutable)definition).getValue());
        DefinitionSpec spec = new DefinitionSpec();
        spec.setKey(specKey);
        spec.setValue((String)definition.getValue());
        return spec;
    }
}

