/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.client.feign.config;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

public class OAuthClientCredentialsFeignManager {
    private static final Logger log = LoggerFactory.getLogger(OAuthClientCredentialsFeignManager.class);
    private final OAuth2AuthorizedClientManager manager;
    private final ClientRegistration clientRegistration;

    public OAuth2AccessToken getAccessToken() {
        try {
            OAuth2AuthorizeRequest oAuth2AuthorizeRequest = this.buildRequest();
            OAuth2AuthorizedClient client = this.manager.authorize(oAuth2AuthorizeRequest);
            if (Objects.isNull(client)) {
                log.error("Client is null for client registration id {}", (Object)this.clientRegistration.getRegistrationId());
                throw new IllegalStateException("Client credentials flow on " + this.clientRegistration.getRegistrationId() + " failed, client is null");
            }
            return client.getAccessToken();
        }
        catch (Exception exp) {
            log.error("Client credentials error, ex: ", (Throwable)exp);
            return null;
        }
    }

    protected OAuth2AuthorizeRequest buildRequest() {
        return OAuth2AuthorizeRequest.withClientRegistrationId((String)this.clientRegistration.getRegistrationId()).principal(this.clientRegistration.getClientId()).build();
    }

    public OAuthClientCredentialsFeignManager(OAuth2AuthorizedClientManager manager, ClientRegistration clientRegistration) {
        this.manager = manager;
        this.clientRegistration = clientRegistration;
    }
}

