/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.cache.service;

import com.icthh.xm.commons.cache.TenantCacheManager;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class TenantAwareCacheManager
implements TenantCacheManager {
    private final CacheManager delegate;
    private final TenantContextHolder tenantContextHolder;

    public TenantAwareCacheManager(CacheManager delegate, TenantContextHolder tenantContextHolder) {
        this.tenantContextHolder = tenantContextHolder;
        this.delegate = delegate;
    }

    public Cache getCache(String name) {
        String currentTenant = this.tenantContextHolder.getTenantKey();
        if (TenantAwareCacheManager.isTenantInvalid(currentTenant)) {
            return null;
        }
        return this.delegate.getCache(TenantCacheManager.buildKey(currentTenant, name));
    }

    public Collection<String> getCacheNames() {
        String currentTenant = this.tenantContextHolder.getTenantKey();
        if (TenantAwareCacheManager.isTenantInvalid(currentTenant)) {
            return List.of();
        }
        return this.getCacheNames(currentTenant);
    }

    @Override
    public void evictCaches() {
        String currentTenant = this.tenantContextHolder.getTenantKey();
        this.getCacheNames(currentTenant).forEach(cacheName -> this.delegate.getCache(TenantCacheManager.buildKey(currentTenant, cacheName)).clear());
    }

    private static boolean isTenantInvalid(String tenant) {
        return tenant == null || tenant.contains("@");
    }

    private Collection<String> getCacheNames(String tenant) {
        String tenantWithDelimiter = TenantCacheManager.buildPrefix(tenant);
        return this.delegate.getCacheNames().stream().filter(cacheName -> cacheName.startsWith(tenantWithDelimiter)).map(cacheName -> cacheName.substring(tenantWithDelimiter.length())).collect(Collectors.toList());
    }
}

