/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.cache.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.icthh.xm.commons.cache.TenantCacheManager;
import com.icthh.xm.commons.cache.config.XmTenantLepCacheConfig;
import com.icthh.xm.commons.cache.service.InitCachesEvent;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.ApplicationListener;

public class DynamicCaffeineCacheManager
extends CaffeineCacheManager
implements ApplicationListener<InitCachesEvent> {
    private static final Logger log = LoggerFactory.getLogger(DynamicCaffeineCacheManager.class);
    private final ConcurrentMap<String, Supplier<Caffeine>> cacheCfgMap = new ConcurrentHashMap<String, Supplier<Caffeine>>(16);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Ticker ticker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(InitCachesEvent event) {
        String tenantName = event.getTenantKey().toUpperCase();
        List<Pair> cacheConfigurationList = event.getCacheList().stream().map(cfg -> Pair.of((Object)TenantCacheManager.buildKey(tenantName, cfg.getCacheName()), (Object)cfg)).toList();
        boolean isLocked = false;
        try {
            isLocked = this.lock.writeLock().tryLock(5L, TimeUnit.SECONDS);
            if (isLocked) {
                String cachePrefix = TenantCacheManager.buildPrefix(tenantName);
                this.cacheCfgMap.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(cachePrefix));
                for (Pair pair : cacheConfigurationList) {
                    this.cacheCfgMap.put((String)pair.getKey(), () -> this.buildSpec((XmTenantLepCacheConfig.XmCacheConfiguration)pair.getValue()));
                }
            }
        }
        catch (InterruptedException e) {
            log.error("Tenant[" + tenantName + "] " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (isLocked) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public Cache getCache(String name) {
        if (!this.cacheCfgMap.keySet().contains(name)) {
            throw new IllegalStateException("Cache with name " + name + " did not exist in cache mapping");
        }
        return super.getCache(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.github.benmanes.caffeine.cache.Cache<Object, Object> createNativeCaffeineCache(String name) {
        boolean isLocked = false;
        com.github.benmanes.caffeine.cache.Cache cache = null;
        try {
            isLocked = this.lock.readLock().tryLock(5L, TimeUnit.SECONDS);
            if (isLocked) {
                Supplier caffeineSupplier = (Supplier)this.cacheCfgMap.get(name);
                Objects.requireNonNull(caffeineSupplier, "Cache configuration [" + name + "] not present in cache map");
                cache = ((Caffeine)caffeineSupplier.get()).build();
            }
        }
        catch (InterruptedException e) {
            log.error("cache[" + name + "] creation failure" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (isLocked) {
                this.lock.readLock().unlock();
            }
        }
        Objects.requireNonNull(cache, "Cache [" + name + "] is locked");
        return cache;
    }

    private Caffeine buildSpec(XmTenantLepCacheConfig.XmCacheConfiguration cacheConfiguration) {
        Caffeine c = Caffeine.newBuilder().ticker(this.ticker);
        this.setMaxSize(c, cacheConfiguration);
        this.setMaxWeight(c, cacheConfiguration);
        this.setExpireAfterWrite(c, cacheConfiguration);
        this.setExpireAfterAccess(c, cacheConfiguration);
        if (cacheConfiguration.isRecordStats()) {
            c.recordStats();
        }
        return c;
    }

    private void setMaxSize(Caffeine cache, XmTenantLepCacheConfig.XmCacheConfiguration cacheConfiguration) {
        Integer maxItems = cacheConfiguration.getMaximumSize();
        if (!XmTenantLepCacheConfig.CACHE_DEFAULTS.equals(maxItems)) {
            cache.maximumSize((long)maxItems.intValue());
        }
    }

    private void setMaxWeight(Caffeine cache, XmTenantLepCacheConfig.XmCacheConfiguration cacheConfiguration) {
        Integer maxWeight = cacheConfiguration.getMaximumWeight();
        if (!XmTenantLepCacheConfig.CACHE_DEFAULTS.equals(maxWeight)) {
            cache.maximumWeight((long)maxWeight.intValue());
        }
    }

    private void setExpireAfterWrite(Caffeine cache, XmTenantLepCacheConfig.XmCacheConfiguration cacheConfiguration) {
        Integer ttlSeconds = cacheConfiguration.getExpireAfterWrite();
        if (!XmTenantLepCacheConfig.CACHE_DEFAULTS.equals(ttlSeconds)) {
            cache.expireAfterWrite((long)ttlSeconds.intValue(), TimeUnit.SECONDS);
        }
    }

    private void setExpireAfterAccess(Caffeine cache, XmTenantLepCacheConfig.XmCacheConfiguration cacheConfiguration) {
        Integer ttlSeconds = cacheConfiguration.getExpireAfterAccess();
        if (!XmTenantLepCacheConfig.CACHE_DEFAULTS.equals(ttlSeconds)) {
            cache.expireAfterAccess((long)ttlSeconds.intValue(), TimeUnit.SECONDS);
        }
    }

    public DynamicCaffeineCacheManager(Ticker ticker) {
        this.ticker = ticker;
    }
}

